/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.token;

import edu.mit.parsing.core.ParsingMessages;
import edu.mit.parsing.core.ParsingPlugin;
import edu.mit.parsing.core.rep.token.ITokenizer;
import edu.mit.parsing.core.rep.token.IndexedToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.AbstractDescFactory2;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.DistinctRegionSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.IntervalSet;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.property.ConfigDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.text.TextRegion;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.ManagerBackedListValidator;
import edu.mit.story.core.validation.PreferenceStoreBackedPropertyDescriptor;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenDescFactory
extends AbstractDescFactory2<IndexedToken> {
    private ITokenizer fTokenizer;

    public TokenDescFactory() {
        super(TokenRep.getInstance(), new IRep[]{CharRep.getInstance(), TextRep.getInstance()});
    }

    protected boolean doInit(IStoryModel model) {
        String id = (String)this.getConfiguration().get((Object)"tokenizer");
        if (id == null) {
            return false;
        }
        this.fTokenizer = (ITokenizer)ParsingPlugin.getDefault().getTokenizerManager().create(id);
        if (this.fTokenizer == null) {
            return false;
        }
        this.fTokenizer.init();
        return true;
    }

    protected IDescSet doCalculateDescriptions(IHasPosition range, IStoryModel provider) {
        DescSet result = new DescSet(this.getRep());
        if (range == null | provider == null) {
            return result;
        }
        IDescSet textDescs = provider.getData().getDescriptions(TextRep.getInstance()).openSet(range);
        IDesc firstTextDesc = null;
        for (IDesc textDesc : textDescs) {
            if (textDesc.getData() != TextRegion.TEXT) continue;
            firstTextDesc = textDesc;
            break;
        }
        if (firstTextDesc == null) {
            return result;
        }
        SimplePosition newRange = new SimplePosition(firstTextDesc.getOffset(), range.getRightOffset() - firstTextDesc.getOffset());
        IHasPositionSet<IndexedToken> indexedData = this.calculateData((IHasPosition)newRange, provider);
        if (indexedData == null) {
            return result;
        }
        for (IndexedToken data : indexedData.openSet(range)) {
            result.add((Object)this.toDescription(data, provider));
        }
        return result;
    }

    protected DistinctRegionSet calculateRegions(StoryChangeEvent event) {
        Change charChange = event.getChange(CharRep.getInstance());
        Change textChange = event.getChange(TextRep.getInstance());
        IHasPositionSet charRegions = charChange == null ? null : charChange.getChanges((IFlag)Flag.DESCS);
        IHasPositionSet textRegions = textChange == null ? null : textChange.getChanges((IFlag)Flag.DESCS);
        IntervalSet result = null;
        if (charRegions != null) {
            IDescSet textDescs = event.provider.getData().getDescriptions(TextRep.getInstance());
            IDescSet tokenDescs = event.provider.getData().getDescriptions(TokenRep.getInstance());
            for (IHasPosition changedRegion : charRegions) {
                for (IDesc textDesc : textDescs.closedSet(changedRegion)) {
                    if (textDesc.getData() != TextRegion.TEXT) continue;
                    if (result == null) {
                        result = new IntervalSet();
                    }
                    result.add(changedRegion);
                    IDescSet tokenSubset = tokenDescs.closedSet(changedRegion);
                    if (tokenSubset.isEmpty()) continue;
                    result.add((IHasPosition)new SimplePosition((IHasPosition)tokenSubset));
                }
            }
        }
        if (textRegions != null) {
            IDescSet textSet = event.provider.getData().getDescriptions(TextRep.getInstance());
            IDescSet tokenSet = event.provider.getData().getDescriptions(TokenRep.getInstance());
            for (IHasPosition changedRegion : textRegions) {
                for (IDesc textDesc : textSet.openSet(changedRegion)) {
                    if (textDesc.getData() != TextRegion.TEXT && tokenSet.openSet((IHasPosition)textDesc).isEmpty()) continue;
                    if (result == null) {
                        result = new IntervalSet();
                    }
                    result.add((IHasPosition)textDesc);
                }
            }
        }
        return result;
    }

    protected IHasPositionSet<IndexedToken> calculateData(IHasPosition region, IStoryModel provider) {
        HasPositionSet result = new HasPositionSet();
        List<IndexedToken> words = this.fTokenizer.tokenize(region.getOffset(), TextRep.getText((IHasPosition)region, (IStoryData)provider.getData()));
        for (IndexedToken word : words) {
            if (word.getRightOffset() <= region.getOffset()) continue;
            if (region.getRightOffset() <= word.getOffset()) break;
            result.add((Object)word);
        }
        return result;
    }

    protected IConfigDescriptor createConfigurationDescriptor() {
        return new TokenFactoryConfigDescriptor(this.getID(), this.getName(), this.getDescription());
    }

    public static class TokenFactoryConfigDescriptor
    extends ConfigDescriptor {
        private static final long serialVersionUID = 1L;

        public TokenFactoryConfigDescriptor(String id, String name, String desc) {
            this();
            this.setID(id);
            this.setName(name);
            this.setDescription(desc);
        }

        public TokenFactoryConfigDescriptor() {
            PreferenceStoreBackedPropertyDescriptor d = new PreferenceStoreBackedPropertyDescriptor("tokenizer", ParsingMessages.FACTORY_PARAM_NAME_Tokenizer, ParsingMessages.FACTORY_PARAM_DESC_Tokenizer, (IValidator)new ManagerBackedListValidator(ParsingPlugin.getDefault().getTokenizerManager()), true, "DefaultTokenizerID", ParsingPlugin.getDefault().getPreferenceStore());
            this.put(d.getID(), d);
        }
    }
}

