/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.evidence;

import edu.mit.wordnet.core.rep.sense.evidence.ContextEvidence;
import edu.mit.wordnet.core.rep.sense.evidence.ContextOverlapMapper;
import edu.mit.wordnet.core.rep.sense.evidence.IEvidence;
import edu.mit.wordnet.core.rep.sense.evidence.MonosemousEvidence;
import edu.mit.wordnet.core.rep.sense.evidence.NumericEvidence;
import edu.mit.wordnet.core.rep.sense.evidence.UserSpecifiedEvidence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EvidenceType {
    USER("Specified by a user"){

        public IEvidence getEvidence(String typeStr, String contentStr) {
            return UserSpecifiedEvidence.getInstance();
        }
    }
    ,
    MONOSEM("Monosemous word with respect to dictionary"){

        public IEvidence getEvidence(String typeStr, String contentStr) {
            return MonosemousEvidence.getInstance();
        }
    }
    ,
    NUMERIC("Numerical assignment of confidence"){

        public IEvidence getEvidence(String typeStr, String contentStr) {
            return new NumericEvidence(Float.parseFloat(contentStr));
        }
    }
    ,
    CONTEXT("Overlap between the word definition and context"){

        public IEvidence getEvidence(String typeStr, String contentStr) {
            return new ContextEvidence(ContextOverlapMapper.getInstance().reconstitute(contentStr));
        }
    };

    private final String desc;

    private EvidenceType(String desc) {
        this.desc = desc;
    }

    public String getID() {
        return this.name();
    }

    public String getDescription() {
        return this.desc;
    }

    public IEvidence getEvidence(String typeStr, String contentStr) {
        throw new IllegalStateException();
    }

    /* synthetic */ EvidenceType(String string, int n, String string2, EvidenceType evidenceType) {
        this(string2);
    }
}

