/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.dict;

import edu.mit.story.core.descriptor.CreatableDescriptor;
import edu.mit.story.core.util.LogUtils;
import edu.mit.story.core.util.StringUtils;
import edu.mit.wordnet.core.WordnetPlugin;
import edu.mit.wordnet.core.rep.sense.dict.ExtendedDictionary;
import edu.mit.wordnet.core.rep.sense.dict.IDictionaryDescriptor;
import edu.mit.wordnet.core.rep.sense.dict.IExtendedDictionary;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryDescriptor
extends CreatableDescriptor<IExtendedDictionary>
implements IDictionaryDescriptor {
    private final String version;
    private final String location;
    private IExtendedDictionary dict;

    public DictionaryDescriptor(IConfigurationElement element, String version, String location) {
        super(element);
        if (location.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.location = location;
        this.version = StringUtils.isEmpty((String)version) ? null : version;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public IExtendedDictionary create() {
        if (this.dict == null) {
            IConfigurationElement element = this.getConfigurationElement();
            String bundleName = element.getContributor().getName();
            Bundle bundle = Platform.getBundle((String)bundleName);
            URL bundleURL = bundle.getEntry(this.location);
            try {
                URL localURL = FileLocator.toFileURL((URL)bundleURL);
                this.dict = new ExtendedDictionary(localURL, this.getID());
                this.dict.open();
            }
            catch (IOException e) {
                LogUtils.logError((Plugin)WordnetPlugin.getDefault(), (Throwable)e);
            }
        }
        return this.dict;
    }
}

