/* Filename: UnknownIndicationTypeProblem.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 02/11/2009
 */
package edu.mit.discourse.core.rep.referent.problems;

import java.util.Collections;

import org.eclipse.core.resources.IMarker;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.core 1.0.0
 */
public class DanglingAppositiveProblem extends StoryProblem {
	
	public static final String ID = "nil.ucm.indications2.core.problem.danglingAppositive";
	
	public DanglingAppositiveProblem(IDesc desc, int id, String buildRuleID) {
		super(desc.getRep(), buildRuleID);
		if(!ReferentRep.getInstance().isType(desc)) throw new IllegalArgumentException();
		setID(ID);
		setName("dangling appositive");
		setSeverity(IMarker.SEVERITY_WARNING);
		setRep(ReferentRep.getInstance());
		setDescs(Collections.singleton(desc));
		
		IReferent referent = (IReferent)desc.getData();
		IReference reference = referent.getReference(id);
		setPosition(reference);
		
		StringBuilder sb = new StringBuilder();
		sb.append("The reference '");
		sb.append(reference.getDisplayText());
		sb.append("' is potentially an appositive; appositives should be integrated with their target references");
		setDescription(sb.toString());
	}

}
