/* Filename: CreateSenseStoryModelChange.java
 * Author: M. A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Mar 2, 2012
 */
package edu.mit.discourse.core.rep.coref;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.factory.FactoryManager;
import edu.mit.story.core.desc.factory.IFactoryDescriptor;
import edu.mit.story.core.desc.factory.IFactoryManager;
import edu.mit.story.core.descriptor.Descriptor;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.AddRepsWithConfigChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveMetadataChange;
import edu.mit.story.core.model.change.RemoveRepresentationsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IRepConfiguration;
import edu.mit.story.core.property.RepConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.text.TextRep;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since StoryWorkbench 1.0
 */
public class GenerateRefexpCorefModelChange extends AbstractModelChange {

	/**
	 * TODO: Write comment
	 *
	 * @param name
	 * @since StoryWorkbench 1.0
	 */
	public GenerateRefexpCorefModelChange() {
		super("Create Event-Timex Annotation Group Story");
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.model.change.AbstractModelChange#doApply(java.lang.Object, edu.mit.story.core.model.IMutableStoryModel)
	 */
	@Override
	protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
		
		// check preconditions
		Set<IRep> exactReps = new HashSet<IRep>(Arrays.asList(CharRep.getInstance(), TextRep.getInstance(), TokenRep.getInstance()));		
		if(!model.supportsAll(exactReps))
			throw new IllegalArgumentException();
		
		// figure out reps to remove
		Set<IRep> removeReps = new HashSet<IRep>(model.getSupported());
		removeReps.removeAll(exactReps);
		
		IFactoryManager factMan = StoryPlugin.getDefault().getFactoryManager();
		
		List<IRep> reps = new LinkedList<IRep>();
		List<IConfiguration> configs = new LinkedList<IConfiguration>();
		IRepConfiguration factConfigs = new RepConfiguration(new Descriptor("factories", "Factory Configurations", null));

		// add refexp rep
		IRep rep = RefExpRep.getInstance();
		reps.add(rep);
		IFactoryDescriptor factDesc = factMan.getDescriptor(FactoryManager.makeNullFactoryID(rep));
		factConfigs.put(rep.getID(), factDesc.getID());
		
		// add coref rep
		rep = CorefRep.getInstance();
		reps.add(rep);
		factDesc = factMan.getDescriptor(FactoryManager.makeNullFactoryID(rep));
		factConfigs.put(rep.getID(), factDesc.getID());
		
		// do changes
		List<IModelChange> changes = new LinkedList<IModelChange>();
		changes.add(new RemoveRepresentationsChange(removeReps));
		changes.add(new AddRepsWithConfigChange(reps, configs, factConfigs));
		changes.add(new RemoveMetadataChange());
		return new CompositeModelChange(changes).apply(source, model);
	}

}
