/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.lucene.store.BufferedIndexOutput;

class FSIndexOutput
extends BufferedIndexOutput {
    RandomAccessFile file = null;

    public FSIndexOutput(File path) throws IOException {
        this.file = new RandomAccessFile(path, "rw");
    }

    public void flushBuffer(byte[] b, int size) throws IOException {
        this.file.write(b, 0, size);
    }

    public void close() throws IOException {
        super.close();
        this.file.close();
    }

    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.file.seek(pos);
    }

    public long length() throws IOException {
        return this.file.length();
    }

    protected void finalize() throws IOException {
        this.file.close();
    }
}

