/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.util;

import edu.mit.story.core.util.IUtilityClass;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayUtils
implements IUtilityClass {
    private static final Map<Class, Object[]> arrayCache = new HashMap<Class, Object[]>();
    private static byte[] emptyByteArray;
    private static short[] emptyShortArray;
    private static int[] emptyIntArray;
    private static long[] emptyLongArray;
    private static float[] emptyFloatArray;
    private static double[] emptyDoubleArray;
    private static boolean[] emptyBooleanArray;
    private static char[] emptyCharArray;
    private static final SortedSet EMPTY_SORTED_SET;
    private static final SortedMap EMPTY_SORTED_MAP;

    static {
        EMPTY_SORTED_SET = new EmptySortedSet();
        EMPTY_SORTED_MAP = new EmptySortedMap();
    }

    private ArrayUtils() {
    }

    public static <T> T[] emptyArray(Class<T> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        Object[] result = arrayCache.get(type);
        if (result == null) {
            result = (Object[])Array.newInstance(type, 0);
            arrayCache.put(type, result);
        }
        return result;
    }

    public static byte[] emptyByteArray() {
        if (emptyByteArray == null) {
            emptyByteArray = new byte[0];
        }
        return emptyByteArray;
    }

    public static short[] emptyShortArray() {
        if (emptyShortArray == null) {
            emptyShortArray = new short[0];
        }
        return emptyShortArray;
    }

    public static int[] emptyIntArray() {
        if (emptyIntArray == null) {
            emptyIntArray = new int[0];
        }
        return emptyIntArray;
    }

    public static long[] emptyLongArray() {
        if (emptyLongArray == null) {
            emptyLongArray = new long[0];
        }
        return emptyLongArray;
    }

    public static float[] emptyFloatArray() {
        if (emptyFloatArray == null) {
            emptyFloatArray = new float[0];
        }
        return emptyFloatArray;
    }

    public static double[] emptyDoubleArray() {
        if (emptyDoubleArray == null) {
            emptyDoubleArray = new double[0];
        }
        return emptyDoubleArray;
    }

    public static boolean[] emptyBooleanArray() {
        if (emptyBooleanArray == null) {
            emptyBooleanArray = new boolean[0];
        }
        return emptyBooleanArray;
    }

    public static char[] emptyCharArray() {
        if (emptyCharArray == null) {
            emptyCharArray = new char[0];
        }
        return emptyCharArray;
    }

    public static <K, V> SortedMap<K, V> emptySortedMap() {
        return EMPTY_SORTED_MAP;
    }

    public static <E> SortedSet<E> emptySortedSet() {
        return EMPTY_SORTED_SET;
    }

    public static <E> List<E> makeNewUnmodifiableList(Collection<? extends E> elements) {
        if (elements == null || elements.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(elements.toArray(new Object[elements.size()])));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptySortedMap
    extends AbstractMap<Object, Object>
    implements Serializable,
    SortedMap<Object, Object> {
        private static final long serialVersionUID = 4514219683208541512L;

        private EmptySortedMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Set<Object> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Collection<Object> values() {
            return Collections.emptySet();
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).size() == 0;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public Comparator<Object> comparator() {
            return null;
        }

        @Override
        public Object firstKey() {
            throw new NoSuchElementException();
        }

        @Override
        public SortedMap<Object, Object> headMap(Object toKey) {
            return this;
        }

        @Override
        public Object lastKey() {
            throw new NoSuchElementException();
        }

        @Override
        public SortedMap<Object, Object> subMap(Object fromKey, Object toKey) {
            return this;
        }

        @Override
        public SortedMap<Object, Object> tailMap(Object fromKey) {
            return this;
        }

        private Object readResolve() {
            return EMPTY_SORTED_MAP;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptySortedSet
    extends AbstractSet<Object>
    implements Serializable,
    SortedSet<Object> {
        private static final long serialVersionUID = -1828060652519866839L;

        private EmptySortedSet() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).size() == 0;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public Comparator<Object> comparator() {
            return null;
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptySet().iterator();
        }

        @Override
        public Object first() {
            throw new NoSuchElementException();
        }

        @Override
        public SortedSet<Object> headSet(Object toElement) {
            return this;
        }

        @Override
        public Object last() {
            throw new NoSuchElementException();
        }

        @Override
        public SortedSet<Object> subSet(Object fromElement, Object toElement) {
            return this;
        }

        @Override
        public SortedSet<Object> tailSet(Object fromElement) {
            return this;
        }

        private Object readResolve() {
            return EMPTY_SORTED_SET;
        }
    }
}

