/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.property;

import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.property.ConfigDescriptor;
import edu.mit.story.core.property.Configuration;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IPropertyDescriptor;
import edu.mit.story.core.property.IRepConfiguration;
import edu.mit.story.core.property.PropertyDescriptor;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.core.util.ImmutableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepConfiguration
extends Configuration
implements IRepConfiguration {
    private final IRepSet supported = new RepSet();
    private IRepSet supportedView;

    public RepConfiguration(IDescriptor d) {
        super(new ConfigDescriptor(d.getID(), d.getName(), d.getDescription()));
    }

    public RepConfiguration(IRepConfiguration c) {
        super(c);
        Iterator<IRep> i = c.repIterator();
        while (i.hasNext()) {
            this.supported.add(i.next());
        }
    }

    @Override
    protected Map<String, IConfiguration> createConfigMap() {
        return new RepConfigMap();
    }

    @Override
    public RepConfiguration clone() {
        return new RepConfiguration(this);
    }

    @Override
    public IRepSet getSupported() {
        if (this.supportedView == null) {
            this.supportedView = RepSet.unmodifiableSet(this.supported);
        }
        return this.supportedView;
    }

    @Override
    public Iterator<IRep> repIterator() {
        return new ImmutableIterator<IRep>(this.supported.iterator());
    }

    @Override
    public int repSize() {
        return this.supported.size();
    }

    @Override
    public boolean supports(IRep rep) {
        return this.supported.supports(rep);
    }

    @Override
    public boolean supportsAll(Collection<? extends IRep> reps) {
        return this.supported.supportsAll(reps);
    }

    @Override
    public boolean addAllSupport(Collection<? extends IRep> reps) {
        boolean result = false;
        for (IRep iRep : reps) {
            result |= this.addSupport(iRep);
        }
        return result;
    }

    @Override
    public boolean addSupport(IRep rep) {
        if (this.supported.add(rep)) {
            IPropertyDescriptor pDesc = this.generateDescriptor(rep);
            this.putProperty(pDesc);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAllSupport(Collection<? extends IRep> reps) {
        boolean result = false;
        for (IRep iRep : reps) {
            result |= this.removeSupport(iRep);
        }
        return result;
    }

    @Override
    public boolean removeSupport(IRep rep) {
        if (this.supported.remove(rep)) {
            this.removeProperty(rep.getID());
            return true;
        }
        return false;
    }

    protected IPropertyDescriptor generateDescriptor(IRep rep) {
        return new PropertyDescriptor(rep.getID(), rep.getName(), rep.getDescription(), rep.getID(), null, true);
    }

    @Override
    public String get(Object key) {
        return key instanceof IRep ? super.get(((IRep)key).getID()) : super.get(key);
    }

    @Override
    public String put(IRep key, String value) {
        return this.put(key.getID(), value);
    }

    @Override
    public IConfiguration getRepConfiguration(IRep rep) {
        return this.getConfigurations().get(rep.getID());
    }

    @Override
    public IConfiguration putRepConfiguration(IRep rep, IConfiguration config) {
        return this.getConfigurations().put(rep.getID(), config);
    }

    protected class RepConfigMap
    extends Configuration.ConfigMap {
        private static final long serialVersionUID = 1L;

        protected RepConfigMap() {
        }

        protected RepConfigMap(int initialCapacity) {
            super(initialCapacity);
        }

        public IConfiguration get(Object key) {
            return key instanceof IRep ? (IConfiguration)super.get(((IRep)key).getID()) : (IConfiguration)super.get(key);
        }
    }
}

