/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.notify;

import edu.mit.story.core.notify.INotifyCollectionCallback;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyingList<E>
extends AbstractList<E> {
    protected final List<E> backingList;
    protected final INotifyCollectionCallback<E> callback;

    public NotifyingList(INotifyCollectionCallback<E> callback) {
        this(new ArrayList(), callback);
    }

    public NotifyingList(List<E> list, INotifyCollectionCallback<E> callback) {
        if (callback == null) {
            throw new NullPointerException();
        }
        if (list == null) {
            throw new NullPointerException();
        }
        this.callback = callback;
        this.backingList = list;
    }

    protected void notifyAdd(E added) {
        this.callback.elementAdded(added);
    }

    protected void notifyRemove(E removed) {
        this.callback.elementRemoved(removed);
    }

    @Override
    public void add(int index, E element) {
        this.backingList.add(index, element);
        this.notifyAdd(element);
    }

    @Override
    public E remove(int index) {
        E removed = this.backingList.remove(index);
        this.notifyRemove(removed);
        return removed;
    }

    @Override
    public E set(int index, E element) {
        E old = this.backingList.set(index, element);
        if (old != element) {
            this.notifyRemove(old);
            this.notifyAdd(element);
        }
        return old;
    }

    @Override
    public E get(int index) {
        return this.backingList.get(index);
    }

    @Override
    public int size() {
        return this.backingList.size();
    }
}

