/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.align;

import edu.mit.story.core.align.Aligner;
import edu.mit.story.core.align.IDescMap;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.rep.IRep;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescMap
extends HashMap<IDesc, IDesc>
implements IDescMap {
    private static final long serialVersionUID = -3511598179157280879L;
    private final IDescSet source;
    private final IDescSet target;
    private final TLongObjectHashMap<IDesc> idMap;

    public DescMap(IDescSet source, IDescSet target, List<? extends Aligner.Pair<IDesc, IDesc>> alignment) {
        if (source.getRep() != target.getRep()) {
            throw new IllegalArgumentException();
        }
        this.source = source;
        this.target = target;
        this.idMap = new TLongObjectHashMap(source.size());
        if (alignment != null) {
            for (Aligner.Pair<IDesc, IDesc> pair : alignment) {
                if (pair.a == null || pair.b == null) continue;
                this.put((IDesc)pair.a, (IDesc)pair.b);
            }
        }
    }

    @Override
    public IRep getRep() {
        return this.source.getRep();
    }

    @Override
    public IDescSet getSource() {
        return this.source;
    }

    @Override
    public IDescSet getTarget() {
        return this.target;
    }

    @Override
    public IDesc getDescription(long id) {
        return (IDesc)this.idMap.get(id);
    }

    @Override
    public IDesc put(IDesc key, IDesc value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        IDesc result = super.put(key, value);
        this.idMap.put(key.getID(), (Object)value);
        return result;
    }

    @Override
    public IDesc remove(Object key) {
        IDesc result = (IDesc)super.remove(key);
        if (result != null) {
            IDesc keyDesc = (IDesc)key;
            this.idMap.remove(keyDesc.getID());
        }
        return result;
    }

    @Override
    public List<Aligner.Pair<IDesc, IDesc>> toAlignment() {
        ArrayList<Aligner.Pair<IDesc, IDesc>> result = new ArrayList<Aligner.Pair<IDesc, IDesc>>();
        for (Map.Entry entry : this.entrySet()) {
            result.add(new Aligner.Pair<IDesc, IDesc>((IDesc)entry.getKey(), (IDesc)entry.getValue()));
        }
        return result;
    }

    public static boolean isInjective(IDescMap map) {
        if (map.getSource().size() != map.getTarget().size()) {
            return false;
        }
        if (map.size() != map.getSource().size()) {
            return false;
        }
        return new HashSet(map.values()).size() == map.getTarget().size();
    }
}

