/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.agreement.rand;

import edu.mit.story.core.agreement.rand.ContingencyTable;
import edu.mit.story.core.agreement.rand.IContingencyTable;
import edu.mit.story.core.agreement.rand.Partitions;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandIndex {
    private static RandIndex instance;

    public static RandIndex getInstance() {
        if (instance == null) {
            instance = new RandIndex();
        }
        return instance;
    }

    protected RandIndex() {
    }

    public <T> double compute(Set<? extends Set<T>> one, Set<? extends Set<T>> two) {
        if (!Partitions.areRelativePartitions(one, two)) {
            throw new IllegalArgumentException();
        }
        return this.compute(this.makeContingencyTable(one, two));
    }

    protected <T> IContingencyTable makeContingencyTable(Set<? extends Set<T>> one, Set<? extends Set<T>> two) {
        return new ContingencyTable(one, two);
    }

    public <T> double compute(IContingencyTable table) {
        double nCh2;
        double result = nCh2 = (double)RandIndex.choose(table.getSum(), 2);
        int r = 0;
        while (r < table.numRows()) {
            int c = 0;
            while (c < table.numColumns()) {
                result += Math.pow(table.get(r, c), 2.0);
                ++c;
            }
            ++r;
        }
        double sumMarginalSqs = 0.0;
        int r2 = 0;
        while (r2 < table.numRows()) {
            sumMarginalSqs += Math.pow(table.getRowSum(r2), 2.0);
            ++r2;
        }
        int c = 0;
        while (c < table.numColumns()) {
            sumMarginalSqs += Math.pow(table.getColumnSum(c), 2.0);
            ++c;
        }
        return (result - sumMarginalSqs / 2.0) / nCh2;
    }

    public static int choose(int n, int k) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (k < 0) {
            throw new IllegalArgumentException();
        }
        if (k > n) {
            return 0;
        }
        if (n == 0) {
            return 1;
        }
        if (k == 0) {
            return 1;
        }
        if (k == n) {
            return 1;
        }
        if (k > n - k) {
            k = n - k;
        }
        int r = 1;
        int i = 1;
        while (i <= k) {
            r *= n - (k - i);
            r /= i;
            ++i;
        }
        return r;
    }
}

