/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.agreement.rand;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Partitions {
    private Partitions() {
    }

    public static <T> void unify(Set<Set<T>> one, Set<Set<T>> two) {
        HashSet<T> inOneButNotTwo = new HashSet<T>();
        HashSet<T> inTwoButNotOne = new HashSet<T>();
        for (Set<T> set : one) {
            for (T obj : set) {
                if (inOneButNotTwo.add(obj)) continue;
                throw new IllegalArgumentException("First set of sets is not a partition by reason of a duplicate entry: " + obj);
            }
        }
        for (Set<T> set : two) {
            for (T obj : set) {
                inOneButNotTwo.remove(obj);
                if (inTwoButNotOne.add(obj)) continue;
                throw new IllegalArgumentException("Second set of sets is not a partition by reason of a duplicate entry: " + obj);
            }
        }
        for (Set<T> set : one) {
            inTwoButNotOne.removeAll(set);
        }
        for (Object obj : inOneButNotTwo) {
            two.add(new HashSet<Object>(Arrays.asList(obj)));
        }
        for (Object obj : inTwoButNotOne) {
            one.add(new HashSet<Object>(Arrays.asList(obj)));
        }
    }

    public static <T> boolean isPartition(Set<Set<T>> partition) {
        HashSet<T> unseen = new HashSet<T>();
        for (Set<T> set : partition) {
            for (T obj : set) {
                if (unseen.add(obj)) continue;
                return false;
            }
        }
        return true;
    }

    public static <T> boolean isPartitionOf(Collection<? extends Set<T>> partition, Set<T> elements) {
        HashSet<T> all = new HashSet<T>();
        for (Set<T> set : partition) {
            for (T obj : set) {
                if (all.add(obj) && elements.contains(obj)) continue;
                return false;
            }
        }
        return all.size() == elements.size();
    }

    public static <T> Set<T> getElements(Collection<? extends Collection<T>> partition) {
        HashSet<T> elements = new HashSet<T>();
        for (Collection<T> set : partition) {
            elements.addAll(set);
        }
        return elements;
    }

    public static <T> boolean areRelativePartitions(Collection<? extends Set<T>> one, Collection<? extends Set<T>> two) {
        Set<T> twoEs;
        Set<T> oneEs = Partitions.getElements(one);
        if (!oneEs.equals(twoEs = Partitions.getElements(two))) {
            return false;
        }
        if (!Partitions.isPartitionOf(one, oneEs)) {
            return false;
        }
        return Partitions.isPartitionOf(two, twoEs);
    }

    public static <T> SetMultimap<T, T> makePairingMap(Collection<? extends Collection<T>> partition) {
        HashMultimap result = HashMultimap.create();
        for (Collection<T> group : partition) {
            for (T element : group) {
                result.putAll(element, Iterables.filter(group, (Predicate)Predicates.not((Predicate)Predicates.equalTo(element))));
            }
        }
        return result;
    }

    public static <B, P> boolean isConsistentWithPartition(Set<Set<B>> subPart, Set<Set<P>> supPart) {
        if (!Partitions.isPartition(supPart)) {
            throw new IllegalArgumentException();
        }
        if (!Partitions.isPartition(subPart)) {
            throw new IllegalArgumentException();
        }
        return Partitions.isConsistentWithPairings(subPart, supPart);
    }

    public static <B, P> boolean isConsistentWithPairings(Set<Set<B>> subPart, Set<Set<P>> supPart) {
        SetMultimap<P, P> supMap = Partitions.makePairingMap(supPart);
        return Partitions.isConsistentWithPairings(subPart, supMap);
    }

    protected static <B, P> boolean isConsistentWithPairings(Set<Set<B>> subPart, Multimap<P, P> supMap) {
        SetMultimap<B, B> subMap = Partitions.makePairingMap(subPart);
        for (Map.Entry e : subMap.entries()) {
            if (supMap.containsEntry(e.getKey(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <B, P> ConsistentPred<B, P> consistent(Collection<? extends Collection<P>> supPart) {
        return new ConsistentPred(supPart);
    }

    public static <B, P> ConsistentPred<B, P> consistent(Multimap<P, P> supMap) {
        return new ConsistentPred(supMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConsistentPred<B, P>
    implements Predicate<Set<Set<B>>> {
        private final Multimap<P, P> supMap;

        public ConsistentPred(Collection<? extends Collection<P>> supPart) {
            this((Multimap<P, P>)Partitions.makePairingMap(supPart));
        }

        public ConsistentPred(Multimap<P, P> supMap) {
            if (supMap == null) {
                throw new NullPointerException();
            }
            this.supMap = supMap;
        }

        public boolean apply(Set<Set<B>> subPart) {
            return Partitions.isConsistentWithPairings(subPart, this.supMap);
        }
    }
}

