/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.actions.delegates;

import edu.mit.parsing.core.util.ParsingUtils;
import edu.mit.parsing.ui.dialogs.WordSelectionDialog;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.ui.actions.delegates.AbstractDelegate;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.editor.StoryEditorUtils;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import edu.mit.wordnet.ui.dialogs.SenseEditorDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class AssignSenseDelegate
extends AbstractDelegate {
    IStoryEditor editor;

    public void setActivePart(IWorkbenchPart activePart) {
        this.editor = StoryEditorUtils.extractStoryEditor((IWorkbenchPart)activePart);
    }

    public void updateAction(IAction action) {
        if (this.editor != null && this.editor.getStoryModel().supports(SenseRep.getInstance())) {
            action.setEnabled(true);
            return;
        }
        action.setEnabled(false);
    }

    public void run(IAction action) {
        if (this.editor == null) {
            return;
        }
        IDescSet tokens = ParsingUtils.getSelectedTokens((IStoryEditor)this.editor);
        if (tokens.isEmpty()) {
            PlatformUI.getWorkbench().getDisplay().beep();
            return;
        }
        IDesc word = WordSelectionDialog.open((IStoryEditor)this.editor);
        if (word == null) {
            return;
        }
        SenseEditorDialog.open(word, this.editor);
    }
}

