/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.misc.ResourceAndContainerGroup;

public class SaveAsDialog
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS_SECTION = "SaveAsDialogSettings";
    private IFile originalFile = null;
    private String originalName = null;
    private IPath result;
    private ResourceAndContainerGroup resourceGroup;
    private Button okButton;
    private Image dlgTitleImage = null;

    public SaveAsDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(IDEWorkbenchMessages.SaveAsDialog_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.save_as_dialog_context");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initializeControls();
        this.validatePage();
        this.resourceGroup.setFocus();
        this.setTitle(IDEWorkbenchMessages.SaveAsDialog_title);
        this.dlgTitleImage = IDEInternalWorkbenchImages.getImageDescriptor("IMG_DLGBAN_SAVEAS_DLG").createImage();
        this.setTitleImage(this.dlgTitleImage);
        this.setMessage(IDEWorkbenchMessages.SaveAsDialog_message);
        return contents;
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                SaveAsDialog.this.setDialogComplete(SaveAsDialog.this.validatePage());
            }
        };
        this.resourceGroup = new ResourceAndContainerGroup(composite, listener, IDEWorkbenchMessages.SaveAsDialog_fileLabel, IDEWorkbenchMessages.SaveAsDialog_file);
        this.resourceGroup.setAllowExistingResources(true);
        return parentComposite;
    }

    public IPath getResult() {
        return this.result;
    }

    private void initializeControls() {
        if (this.originalFile != null) {
            this.resourceGroup.setContainerFullPath(this.originalFile.getParent().getFullPath());
            this.resourceGroup.setResource(this.originalFile.getName());
        } else if (this.originalName != null) {
            this.resourceGroup.setResource(this.originalName);
        }
        this.setDialogComplete(this.validatePage());
    }

    protected void okPressed() {
        IFile file;
        IPath path = this.resourceGroup.getContainerFullPath().append(this.resourceGroup.getResource());
        if (path.getFileExtension() == null) {
            if (this.originalFile != null && this.originalFile.getFileExtension() != null) {
                path = path.addFileExtension(this.originalFile.getFileExtension());
            } else if (this.originalName != null) {
                int pos = this.originalName.lastIndexOf(46);
                if (++pos > 0 && pos < this.originalName.length()) {
                    path = path.addFileExtension(this.originalName.substring(pos));
                }
            }
        }
        if ((file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)).exists()) {
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            String question = NLS.bind((String)IDEWorkbenchMessages.SaveAsDialog_overwriteQuestion, (Object)path.toString());
            MessageDialog d = new MessageDialog(this.getShell(), IDEWorkbenchMessages.Question, null, question, 3, buttons, 0);
            int overwrite = d.open();
            switch (overwrite) {
                case 0: {
                    break;
                }
                case 1: {
                    return;
                }
                default: {
                    this.cancelPressed();
                    return;
                }
            }
        }
        this.result = path;
        this.close();
    }

    protected void setDialogComplete(boolean value) {
        this.okButton.setEnabled(value);
    }

    public void setOriginalFile(IFile originalFile) {
        this.originalFile = originalFile;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    private boolean validatePage() {
        IProject project;
        String projectName;
        IStatus isValidProjectName;
        if (!this.resourceGroup.areAllValuesValid()) {
            if (!this.resourceGroup.getResource().equals("")) {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            } else {
                this.setErrorMessage(null);
            }
            return false;
        }
        String resourceName = this.resourceGroup.getResource();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath fullPath = this.resourceGroup.getContainerFullPath();
        if (fullPath != null && (isValidProjectName = workspace.validateName(projectName = fullPath.segment(0), 4)).isOK() && !(project = workspace.getRoot().getProject(projectName)).isOpen()) {
            this.setErrorMessage(IDEWorkbenchMessages.SaveAsDialog_closedProjectMessage);
            return false;
        }
        IStatus result = workspace.validateName(resourceName, 1);
        if (!result.isOK()) {
            this.setErrorMessage(result.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    protected boolean isResizable() {
        return true;
    }
}

