/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.colloc;

import edu.mit.jmwe.data.IMWE;
import edu.mit.jmwe.data.IToken;
import edu.mit.jmwe.detect.CompositeDetector;
import edu.mit.jmwe.detect.Consecutive;
import edu.mit.jmwe.detect.IMWEDetector;
import edu.mit.jmwe.detect.InflectionPattern;
import edu.mit.jmwe.detect.MoreFrequentAsMWE;
import edu.mit.jmwe.detect.ProperNouns;
import edu.mit.jmwe.index.IMWEIndex;
import edu.mit.parsing.core.ParsingPlugin;
import edu.mit.parsing.core.rep.colloc.ICollocDetector;
import edu.mit.story.core.algorithm.AbstractAlgorithm;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BestJMWECollocDetector
extends AbstractAlgorithm
implements ICollocDetector {
    private IMWEDetector detector;

    protected boolean doInit() {
        IMWEIndex index = ParsingPlugin.getDefault().getMWEIndex();
        if (index == null) {
            return false;
        }
        ProperNouns pnd = ProperNouns.getInstance();
        this.detector = new CompositeDetector(new IMWEDetector[]{pnd, new MoreFrequentAsMWE((IMWEDetector)new InflectionPattern((IMWEDetector)new Consecutive(index)))});
        return true;
    }

    public IMWEDetector getBackingDetector() {
        return this.detector;
    }

    public <T extends IToken> List<IMWE<T>> detect(List<T> sentence) {
        this.checkInit();
        return this.detector.detect(sentence);
    }

    public void dispose() {
        this.detector = null;
        super.dispose();
    }
}

