/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Synset;

public class SynsetID
implements ISynsetID {
    public static final String synsetIDPrefix = "SID-";
    private int fOffset = -1;
    private POS fPOS = null;
    private static char hyphen = (char)45;

    public SynsetID(int offset, POS pos) {
        if (pos == null) {
            throw new NullPointerException();
        }
        Synset.checkOffset(offset);
        this.fOffset = offset;
        this.fPOS = pos;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public POS getPOS() {
        return this.fPOS;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.fOffset;
        result = 31 * result + this.fPOS.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ISynsetID)) {
            return false;
        }
        ISynsetID other = (ISynsetID)obj;
        if (this.fOffset != other.getOffset()) {
            return false;
        }
        return this.fPOS.equals((Object)other.getPOS());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(synsetIDPrefix);
        sb.append(Synset.zeroFillOffset(this.fOffset));
        sb.append(hyphen);
        sb.append(Character.toUpperCase(this.fPOS.getTag()));
        return sb.toString();
    }

    public static SynsetID parseSynsetID(String value) {
        if (value == null || value.length() != 14) {
            return null;
        }
        if (!value.startsWith(synsetIDPrefix)) {
            return null;
        }
        int offset = 0;
        try {
            offset = Integer.parseInt(value.substring(4, 12));
        }
        catch (Exception e) {
            return null;
        }
        char tag = Character.toLowerCase(value.charAt(13));
        POS pos = null;
        try {
            pos = POS.getPartOfSpeech(tag);
        }
        catch (Exception e) {
            return null;
        }
        return new SynsetID(offset, pos);
    }
}

