/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.controllers;

import edu.mit.discourse.ui.controllers.CorefSelectionDialogCaptureStrategy;
import edu.mit.semantics.core.rep.mentalstate.IMentalState;
import edu.mit.semantics.core.rep.mentalstate.MentalStateRep;
import edu.mit.semantics.core.rep.mentalstate.model.IMentalStateModel;
import edu.mit.semantics.core.rep.mentalstate.model.MentalStateModel;
import edu.mit.semantics.core.rep.valence.Valence;
import edu.mit.semantics.ui.controllers.IMentalStateController;
import edu.mit.story.core.datamodel.IDescModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.controllers.DescController;
import edu.mit.story.ui.controllers.ICaptureStrategy;
import edu.mit.story.ui.controllers.IDescController;
import edu.mit.story.ui.editor.IStoryEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MentalStateController
implements IMentalStateController {
    private final IStoryEditor editor;
    private final IMentalStateModel stateModel;
    private final IDescController<IDescModel> eventController;
    private final IDescController<IDescModel> charController;

    public MentalStateController(IStoryEditor editor) {
        this(editor, "edu.mit.story.ui.annotation.target1", "edu.mit.story.ui.annotation.target2");
    }

    public MentalStateController(IStoryEditor editor, String eventAnnoID, String charAnnoID) {
        MentalStateModel stateModel = new MentalStateModel((IStoryModel)editor.getStoryModel());
        DescController eventController = new DescController(stateModel.getEventModel(), eventAnnoID, editor);
        DescController charController = new DescController(stateModel.getCharacterModel(), charAnnoID, editor, (ICaptureStrategy)new CorefSelectionDialogCaptureStrategy(editor, stateModel.getCharacterModel()));
        this.editor = editor;
        this.stateModel = stateModel;
        this.eventController = eventController;
        this.charController = charController;
    }

    @Override
    public void setValence(Valence valence) {
        this.stateModel.setValence(valence);
    }

    @Override
    public void clear() {
        this.stateModel.clear();
    }

    @Override
    public void commit() {
        IMentalStateModel model = this.getModel();
        if (model.getMessageType() == 3) {
            return;
        }
        Timing timing = new Timing(model.getStart(), "user");
        IMentalState data = model.create();
        IHasPosition p = data.calculatePosition();
        ChangeUtils.edit((Object)this, (IMutableStoryModel)this.getStoryEditor().getStoryModel(), (IRep)MentalStateRep.getInstance(), (IHasPosition)p, (IData)data, (ITiming)timing, (IDesc)model.getLoaded());
        this.clear();
    }

    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    @Override
    public void edit(IDesc mentalStateDesc) {
        this.stateModel.load(mentalStateDesc);
    }

    @Override
    public IDescController<IDescModel> getCharacterController() {
        return this.charController;
    }

    @Override
    public IDescController<IDescModel> getEventController() {
        return this.eventController;
    }

    @Override
    public IMentalStateModel getModel() {
        return this.stateModel;
    }

    public void dispose() {
        this.charController.dispose();
        this.eventController.dispose();
    }
}

