/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.algorithm;

import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.wordnet.core.WordnetUtils;
import edu.mit.wordnet.core.rep.sense.ISenseAssignment;
import edu.mit.wordnet.core.rep.sense.SenseAssignment;
import edu.mit.wordnet.core.rep.sense.algorithm.AbstractSenseTagger;
import edu.mit.wordnet.core.rep.sense.evidence.NumericEvidence;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MostFrequentSenseTagger
extends AbstractSenseTagger {
    @Override
    public List<ISenseAssignment> doTag(IBaseWordInfo word) {
        IPosData posTag = word.getPosTag();
        if (posTag == null) {
            return Collections.emptyList();
        }
        POS pos = WordnetUtils.convertToPOS(posTag.getTag());
        if (pos == null) {
            return Collections.emptyList();
        }
        IIndexWord idxWord = this.getDictionary().getIndexWord(word.getBaseForm(), pos);
        if (idxWord == null) {
            return Collections.emptyList();
        }
        List wordIDs = idxWord.getWordIDs();
        IWord wnWord = this.getDictionary().getWord((IWordID)wordIDs.get(0));
        return Collections.singletonList(new SenseAssignment(wnWord, new NumericEvidence(1.0f)));
    }
}

