/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.viewers;

import java.util.EventObject;
import org.eclipse.equinox.internal.p2.ui.BatchChangeBeginningEvent;
import org.eclipse.equinox.internal.p2.ui.BatchChangeCompleteEvent;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.repository.RepositoryEvent;
import org.eclipse.equinox.internal.provisional.p2.engine.ProfileEvent;
import org.eclipse.equinox.internal.provisional.p2.ui.model.ProfileElement;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IQueryProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class StructuredViewerProvisioningListener
implements ProvisioningListener {
    public static final int PROV_EVENT_METADATA_REPOSITORY = 1;
    public static final int PROV_EVENT_IU = 2;
    public static final int PROV_EVENT_PROFILE = 4;
    public static final int PROV_EVENT_ARTIFACT_REPOSITORY = 8;
    int eventTypes = 0;
    int batchCount = 0;
    StructuredViewer viewer;
    Display display;
    IQueryProvider queryProvider;

    public StructuredViewerProvisioningListener(StructuredViewer viewer, int eventTypes, IQueryProvider queryProvider) {
        this.viewer = viewer;
        this.eventTypes = eventTypes;
        this.display = viewer.getControl().getDisplay();
        this.queryProvider = queryProvider;
    }

    public void notify(EventObject o) {
        if (o instanceof BatchChangeBeginningEvent) {
            ++this.batchCount;
        } else if (o instanceof BatchChangeCompleteEvent) {
            --this.batchCount;
            if (this.batchCount <= 0) {
                this.asyncRefresh();
            }
        } else {
            RepositoryEvent event;
            if (this.batchCount > 0) {
                return;
            }
            if (o instanceof ProfileEvent && ((this.eventTypes & 2) == 2 || (this.eventTypes & 4) == 4)) {
                ProfileEvent event2 = (ProfileEvent)o;
                if (event2.getReason() == 2) {
                    this.profileChanged(event2.getProfileId());
                } else if (event2.getReason() == 0) {
                    this.profileAdded(event2.getProfileId());
                } else if (event2.getReason() == 1) {
                    this.profileRemoved(event2.getProfileId());
                }
            } else if (o instanceof RepositoryEvent && ((event = (RepositoryEvent)o).getRepositoryType() == 0 && (this.eventTypes & 1) == 1 || event.getRepositoryType() == 1 && (this.eventTypes & 8) == 8)) {
                if (event.getKind() == 0) {
                    this.repositoryAdded(event);
                } else if (event.getKind() == 1) {
                    this.repositoryRemoved(event);
                } else if (event.getKind() == 4) {
                    this.repositoryDiscovered(event);
                } else if (event.getKind() == 2) {
                    this.repositoryChanged(event);
                }
            }
        }
    }

    protected void repositoryAdded(RepositoryEvent event) {
        this.asyncRefresh();
    }

    protected void repositoryRemoved(RepositoryEvent event) {
        this.asyncRefresh();
    }

    protected void repositoryDiscovered(RepositoryEvent event) {
    }

    protected void repositoryChanged(RepositoryEvent event) {
    }

    protected void profileChanged(final String profileId) {
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (StructuredViewerProvisioningListener.this.isClosing()) {
                    return;
                }
                ProfileElement element = new ProfileElement(profileId);
                element.setQueryProvider(StructuredViewerProvisioningListener.this.queryProvider);
                StructuredViewerProvisioningListener.this.viewer.refresh((Object)element);
            }
        });
    }

    protected void profileAdded(String profileId) {
        this.asyncRefresh();
    }

    protected void profileRemoved(String profileId) {
        this.asyncRefresh();
    }

    protected void asyncRefresh() {
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (StructuredViewerProvisioningListener.this.isClosing()) {
                    return;
                }
                StructuredViewerProvisioningListener.this.refreshAll();
            }
        });
    }

    protected void refreshAll() {
        this.viewer.refresh();
    }

    public int getEventTypes() {
        return this.eventTypes;
    }

    protected boolean isClosing() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench.isClosing()) {
            return true;
        }
        return this.viewer.getControl().isDisposed();
    }
}

