/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.AvailableUpdateElement;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.IProfileChooser;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.ProfileModificationAction;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.UpdateWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policies;
import org.eclipse.equinox.internal.provisional.p2.ui.query.ElementQueryDescriptor;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.UpdateEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class UpdateAction
extends ProfileModificationAction {
    ArrayList allReplacements;
    HashMap latestReplacements;
    static /* synthetic */ Class class$0;

    public UpdateAction(ISelectionProvider selectionProvider, String profileId, IProfileChooser chooser, Policies policies, Shell shell) {
        super(ProvUI.UPDATE_COMMAND_LABEL, selectionProvider, profileId, chooser, policies, shell);
        this.setToolTipText(ProvUI.UPDATE_COMMAND_TOOLTIP);
    }

    protected int performOperation(IInstallableUnit[] ius, String targetProfileId, ProvisioningPlan plan) {
        Assert.isNotNull((Object)this.latestReplacements);
        Assert.isNotNull((Object)this.allReplacements);
        Assert.isNotNull((Object)plan);
        UpdateWizard wizard = new UpdateWizard(targetProfileId, ius, this.allReplacements.toArray(new AvailableUpdateElement[this.allReplacements.size()]), this.latestReplacements.values().toArray(), plan, this.getLicenseManager());
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.equinox.p2.ui.update_wizard_context");
        return dialog.open();
    }

    protected ProvisioningPlan getProvisioningPlan(IInstallableUnit[] ius, String targetProfileId, IProgressMonitor monitor) throws ProvisionException {
        ArrayList<IInstallableUnit> toBeUpdated = new ArrayList<IInstallableUnit>();
        this.latestReplacements = new HashMap();
        this.allReplacements = new ArrayList();
        int i = 0;
        while (i < ius.length) {
            UpdateEvent event = new UpdateEvent(targetProfileId, new IInstallableUnit[]{ius[i]});
            ElementQueryDescriptor descriptor = this.getQueryProvider().getQueryDescriptor(event, 5);
            Iterator iter = descriptor.queryable.query(descriptor.query, descriptor.collector, null).iterator();
            if (iter.hasNext()) {
                toBeUpdated.add(ius[i]);
            }
            ArrayList<AvailableUpdateElement> currentReplacements = new ArrayList<AvailableUpdateElement>();
            while (iter.hasNext()) {
                IInstallableUnit iu;
                Object e = iter.next();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iu = (IInstallableUnit)ProvUI.getAdapter(e, clazz)) == null) continue;
                AvailableUpdateElement element = new AvailableUpdateElement(iu, ius[i], targetProfileId);
                currentReplacements.add(element);
                this.allReplacements.add(element);
            }
            int j = 0;
            while (j < currentReplacements.size()) {
                IInstallableUnit latestIU;
                AvailableUpdateElement replacementElement = (AvailableUpdateElement)currentReplacements.get(j);
                AvailableUpdateElement latestElement = (AvailableUpdateElement)this.latestReplacements.get(replacementElement.getIU().getId());
                IInstallableUnit iInstallableUnit = latestIU = latestElement == null ? null : latestElement.getIU();
                if (latestIU == null || replacementElement.getIU().getVersion().compareTo((Object)latestIU.getVersion()) > 0) {
                    this.latestReplacements.put(replacementElement.getIU().getId(), replacementElement);
                }
                ++j;
            }
            ++i;
        }
        if (toBeUpdated.size() <= 0) {
            return new ProvisioningPlan((IStatus)new Status(1, "org.eclipse.equinox.p2.ui", 10000, ProvUIMessages.UpdateOperation_NothingToUpdate, null));
        }
        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((String)targetProfileId);
        Iterator<Object> iter = toBeUpdated.iterator();
        while (iter.hasNext()) {
            request.removeInstallableUnits(new IInstallableUnit[]{(IInstallableUnit)iter.next()});
        }
        iter = this.latestReplacements.values().iterator();
        while (iter.hasNext()) {
            request.addInstallableUnits(new IInstallableUnit[]{((AvailableUpdateElement)iter.next()).getIU()});
        }
        ProvisioningPlan plan = ProvisioningUtil.getProvisioningPlan(request, new ProvisioningContext(), monitor);
        return plan;
    }

    protected boolean isEnabledFor(Object[] selectionArray) {
        Object parent = null;
        IProfile profile = this.getProfile(false);
        if (profile == null) {
            return false;
        }
        if (selectionArray.length > 0) {
            int i = 0;
            while (i < selectionArray.length) {
                if (selectionArray[i] instanceof InstalledIUElement) {
                    InstalledIUElement element = (InstalledIUElement)selectionArray[i];
                    int lock = this.getLock(profile, element.getIU());
                    if ((lock & 2) == 2) {
                        return false;
                    }
                    if (parent == null) {
                        parent = element.getParent(null);
                    } else if (parent != element.getParent(null)) {
                        return false;
                    }
                } else {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected String getTaskName() {
        return ProvUIMessages.UpdateIUProgress;
    }
}

