/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.actions;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescMultiSet;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.element.IStoryElement;
import edu.mit.story.core.element.IStoryElementSet;
import edu.mit.story.core.element.StoryElementSet;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.IUndoableStoryModel;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.util.Debug;
import edu.mit.story.core.util.IUtilityClass;
import edu.mit.story.ui.actions.DescActionUtils;
import edu.mit.story.ui.actions.RepActionUtils;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.StoryElementSetActionUtils;
import edu.mit.story.ui.clipboard.ClipboardUtils;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;

public final class StoryElementActionUtils
implements IUtilityClass {
    public static final Map<ISelection, IStoryElement> cache = new WeakHashMap<ISelection, IStoryElement>();

    private StoryElementActionUtils() {
    }

    public static IStoryElement extractStoryElementWithCache(ISelection selection) {
        IStoryElement result = cache.get(selection);
        if (result != null | cache.keySet().contains(selection)) {
            return result;
        }
        result = StoryElementActionUtils.getStoryElement(selection);
        cache.put(selection, result);
        return result;
    }

    public static IStoryElement getStoryElement(ISelection selection) {
        IStructuredSelection struct = SelectionUtils.castAsStructuredSelection(selection);
        if (struct == null) {
            return null;
        }
        StoryElementSet result = null;
        for (Object element : struct) {
            if (!(element instanceof IStoryElement)) continue;
            if (result == null) {
                result = new StoryElementSet();
            }
            result.add((Object)((IStoryElement)element));
        }
        return result == null ? null : result.compress();
    }

    public static boolean hasProperties(IStoryElement so) {
        if (so == null) {
            return false;
        }
        switch (so.getImplementationCode()) {
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean canCut(IStoryElement so, IMutableStoryModel provider) {
        if (so == null) {
            return false;
        }
        switch (so.getImplementationCode()) {
            case 1: {
                return RepActionUtils.canCut((IRep)so, provider);
            }
            case 2: {
                return RepActionUtils.canCut((IRepSet)so, provider);
            }
            case 5: {
                return DescActionUtils.canCut((IDesc)so, provider);
            }
            case 6: {
                return DescActionUtils.canCut((IDescSet)so, provider);
            }
            case 7: {
                return DescActionUtils.canCut((IDescMultiSet)so, provider);
            }
            case 9: {
                return StoryElementSetActionUtils.canCut((IStoryElementSet)so, provider);
            }
        }
        return false;
    }

    public static boolean canCopy(IStoryElement so) {
        if (so == null) {
            return false;
        }
        switch (so.getImplementationCode()) {
            case 1: {
                return RepActionUtils.canCopy((IRep)so);
            }
            case 2: {
                return RepActionUtils.canCopy((IRepSet)so);
            }
            case 5: {
                return DescActionUtils.canCopy((IDesc)so);
            }
            case 6: {
                return DescActionUtils.canCopy((IDescSet)so);
            }
            case 7: {
                return DescActionUtils.canCopy((IDescMultiSet)so);
            }
            case 9: {
                return StoryElementSetActionUtils.canCopy((IStoryElementSet)so);
            }
        }
        return false;
    }

    public static boolean canPaste(Clipboard clipboard, IMutableStoryModel provider) {
        if (clipboard == null | provider == null) {
            return false;
        }
        IStoryElement so = null;
        if (so == null) {
            return false;
        }
        Debug.out((String)("Got story object from clipboard: " + so));
        if (so == null) {
            return false;
        }
        return StoryElementActionUtils.canPaste(so, provider);
    }

    public static boolean canPaste(IStoryElement so, IMutableStoryModel provider) {
        if (so == null | provider == null) {
            return false;
        }
        switch (so.getImplementationCode()) {
            case 1: {
                return RepActionUtils.canPaste((IRep)so, provider);
            }
            case 2: {
                return RepActionUtils.canPaste((IRepSet)so, provider);
            }
            case 5: {
                return DescActionUtils.canPaste((IDesc)so, (IStoryModel)provider);
            }
            case 6: {
                return DescActionUtils.canPaste((IDesc)so, (IStoryModel)provider);
            }
            case 7: {
                return DescActionUtils.canPaste((IDescMultiSet)so, (IStoryModel)provider);
            }
            case 9: {
                return StoryElementSetActionUtils.canPaste((IStoryElementSet)so, provider);
            }
        }
        return false;
    }

    public static boolean canDelete(IStoryElement so, IMutableStoryModel provider) {
        if (so == null | provider == null) {
            return false;
        }
        switch (so.getImplementationCode()) {
            case 1: {
                return RepActionUtils.canDelete((IRep)so, provider);
            }
            case 2: {
                return RepActionUtils.canDelete((IRepSet)so, (IStoryModel)provider);
            }
            case 5: {
                return DescActionUtils.canDelete((IDesc)so, provider);
            }
            case 6: {
                return DescActionUtils.canDelete((Collection<? extends IDesc>)((IDescSet)so), provider);
            }
            case 7: {
                return DescActionUtils.canDelete((Collection<? extends IDesc>)((IDescMultiSet)so), provider);
            }
            case 9: {
                return StoryElementSetActionUtils.canDelete((IStoryElementSet)so, provider);
            }
        }
        return false;
    }

    public static boolean canEdit(IStoryElement so, IMutableStoryModel provider) {
        if (so == null | provider == null) {
            return false;
        }
        switch (so.getImplementationCode()) {
            case 5: {
                return DescActionUtils.canDelete((IDesc)so, provider);
            }
            case 6: {
                return DescActionUtils.canDelete((Collection<? extends IDesc>)((IDescSet)so), provider);
            }
            case 7: {
                return DescActionUtils.canDelete((Collection<? extends IDesc>)((IDescMultiSet)so), provider);
            }
        }
        return false;
    }

    public static boolean doCut(Object source, IStoryElement so, IMutableStoryModel provider, Clipboard clipboard) {
        if (so == null | provider == null | clipboard == null) {
            return false;
        }
        switch (so.getImplementationCode()) {
            case 1: {
                return RepActionUtils.doCut(source, (IRep)so, provider, clipboard);
            }
            case 2: {
                return RepActionUtils.doCut(source, (IRepSet)so, provider, clipboard);
            }
            case 5: {
                return DescActionUtils.doCut(source, (IDesc)so, provider, clipboard);
            }
            case 6: {
                return DescActionUtils.doCut(source, (IDescSet)so, provider, clipboard);
            }
            case 7: {
                return DescActionUtils.doCut(source, (IDescMultiSet)so, provider, clipboard);
            }
            case 9: {
                return StoryElementSetActionUtils.doCut(source, (IStoryElementSet)so, provider, clipboard);
            }
        }
        return false;
    }

    public static boolean doCopy(Object source, IStoryElement so, Clipboard clipboard) {
        if (so == null) {
            return false;
        }
        switch (so.getImplementationCode()) {
            case 1: {
                return RepActionUtils.doCopy((IRep)so, clipboard);
            }
            case 2: {
                return RepActionUtils.doCopy((IRepSet)so, clipboard);
            }
            case 5: {
                return DescActionUtils.doCopy(source, (IDesc)so, clipboard);
            }
            case 6: {
                return DescActionUtils.doCopy(source, (IDescSet)so, clipboard);
            }
            case 7: {
                return DescActionUtils.doCopy(source, (IDescMultiSet)so, clipboard);
            }
            case 9: {
                return StoryElementSetActionUtils.doCopy(source, (IStoryElementSet)so, clipboard);
            }
        }
        return false;
    }

    public static boolean doCopyData(Object source, IStoryElement so, Clipboard clipboard, IStoryModel provider) {
        if (so == null | clipboard == null) {
            return false;
        }
        switch (so.getImplementationCode()) {
            case 1: {
                return RepActionUtils.doCopyData((IRep)so, provider, clipboard);
            }
            case 2: {
                return RepActionUtils.doCopyData((IRepSet)so, provider, clipboard);
            }
            case 5: {
                return DescActionUtils.doCopyData(source, (IDesc)so, clipboard);
            }
            case 6: {
                return DescActionUtils.doCopyData(source, (IDescSet)so, clipboard);
            }
            case 7: {
                return DescActionUtils.doCopyData(source, (IDescMultiSet)so, clipboard);
            }
            case 9: {
                return StoryElementSetActionUtils.doCopyData(source, (IStoryElementSet)so, clipboard);
            }
        }
        return false;
    }

    public static boolean doPaste(Object source, Clipboard clipboard, IStoryEditor editor) {
        if (clipboard == null | editor == null) {
            return false;
        }
        IStoryElement so = ClipboardUtils.getStoryObject(clipboard);
        Debug.out((String)("Got story object: " + so));
        if (so == null) {
            return false;
        }
        return StoryElementActionUtils.doPaste(source, so, editor);
    }

    public static boolean doPaste(Object source, IStoryElement so, IStoryEditor editor) {
        if (so == null | editor == null) {
            return false;
        }
        switch (so.getImplementationCode()) {
            case 1: 
            case 2: 
            case 5: {
                return false;
            }
            case 6: {
                return false;
            }
            case 7: {
                return false;
            }
            case 9: {
                return false;
            }
        }
        return false;
    }

    public static boolean doDelete(Object source, IStoryElement so, IMutableStoryModel provider) {
        if (so == null | provider == null) {
            return false;
        }
        switch (so.getImplementationCode()) {
            case 1: {
                return RepActionUtils.doDelete(source, (IRep)so, provider);
            }
            case 2: {
                return RepActionUtils.doDelete(source, (IRepSet)so, provider);
            }
            case 5: {
                return DescActionUtils.doDelete(source, (IDesc)so, provider);
            }
            case 6: {
                return DescActionUtils.doDelete(source, (Collection<? extends IDesc>)((IDescSet)so), provider);
            }
            case 7: {
                return DescActionUtils.doDelete(source, (Collection<? extends IDesc>)((IDescMultiSet)so), provider);
            }
            case 9: {
                return StoryElementSetActionUtils.doDelete(source, (IStoryElementSet)so, provider);
            }
        }
        return false;
    }

    public static boolean doEdit(Object source, IStoryElement so, IStoryEditor editor) {
        if (so == null | editor == null) {
            return false;
        }
        IUndoableStoryModel provider = editor.getStoryModel();
        switch (so.getImplementationCode()) {
            case 5: {
                return DescActionUtils.doEdit(source, (IDesc)so, (IMutableStoryModel)provider, editor);
            }
            case 6: {
                return DescActionUtils.doEdit(source, (IDescSet)so, (IMutableStoryModel)provider, editor);
            }
        }
        return false;
    }
}

