/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.tuebadz;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.tuebadz.TueBaDZLanguagePack;

public class TueBaDZPennTreeNormalizer
extends TreeNormalizer {
    private static String root = "ROOT";
    private static String nonUnaryRoot = "ROOT";
    protected final TreebankLanguagePack tlp;

    public String rootSymbol() {
        return root;
    }

    public String nonUnaryRootSymbol() {
        return nonUnaryRoot;
    }

    public TueBaDZPennTreeNormalizer() {
        this(new TueBaDZLanguagePack());
    }

    public TueBaDZPennTreeNormalizer(TreebankLanguagePack tlp) {
        this.tlp = tlp;
    }

    public String normalizeTerminal(String leaf) {
        return leaf.intern();
    }

    public String normalizeNonterminal(String category) {
        return this.cleanUpLabel(category).intern();
    }

    protected String cleanUpLabel(String label) {
        if (label == null) {
            label = root;
        }
        return label;
    }

    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        if (tree.label().value().equals(root) && tree.children().length > 1) {
            Tree underRoot = tree.treeFactory().newTreeNode(nonUnaryRoot, tree.getChildrenAsList());
            tree.setChildren(new Tree[1]);
            tree.setChild(0, underRoot);
        }
        return tree;
    }
}

