/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.MapLabel;
import edu.stanford.nlp.ling.StringLabel;

public class MapLabelFactory
implements LabelFactory {
    public Label newLabel(String str) {
        return new MapLabel(str);
    }

    public Label newLabel(String str, int options) {
        return this.newLabel(str);
    }

    public Label newLabelFromString(String str) {
        return this.newLabel(str);
    }

    public Label newLabel(Label oldLabel) {
        return new MapLabel(oldLabel);
    }

    public static void main(String[] args) {
        MapLabelFactory lf = new MapLabelFactory();
        System.out.println("new label from String: " + ((MapLabel)lf.newLabel("foo")).toString("value{map}"));
        System.out.println("new label from StringLabel: " + ((MapLabel)lf.newLabel(new StringLabel("foo"))).toString("value{map}"));
        CategoryWordTag cwt = new CategoryWordTag("cat", "word", "tag");
        MapLabel label = (MapLabel)lf.newLabel(cwt);
        System.out.println("new label from CategoryWordTag: " + label.toString("value{map}"));
        label.put("temp", "hot");
        System.out.println("new label from MapLabel: " + ((MapLabel)lf.newLabel(label)).toString("value{map}"));
    }
}

