/* Filename: RefExpTranslationFactory.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: May 7, 2010
 */
package edu.mit.discourse.core.rep.refexp;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.AbstractDescFactory2;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.DistinctRegionSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public class RefExpTranslationFactory extends AbstractDescFactory2<IndexedRefExp> {
	
	public static final String ID = "edu.mit.discourse.rep.refexp.factory.translation";

	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @param requiredRep
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public RefExpTranslationFactory() {
		super(RefExpRep.getInstance(), ReferentRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.factory.AbstractDescFactory2#calculateRegions(edu.mit.story.core.model.change.StoryChangeEvent)
	 */
	@Override
	protected DistinctRegionSet calculateRegions(StoryChangeEvent event) {
		// this factory is not intended to generate any data
		return null;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.factory.AbstractDescFactory2#calculateData(edu.mit.story.core.position.IHasPosition, edu.mit.story.core.model.IStoryModel)
	 */
	@Override
	protected IHasPositionSet<IndexedRefExp> calculateData(IHasPosition region, IStoryModel model) {
		
		if(!model.supports(ReferentRep.getInstance()))
			return null;
		
		// collect all references in region
		IDescSet refDescs = model.getData().getDescriptions(ReferentRep.getInstance()).openSet(region);
		IHasPositionSet<IReference> refs = new HasPositionSet<IReference>();
		IReferent coref; 
		for(IDesc refDesc : refDescs){
			coref = (IReferent)refDesc.getData();
			refs.addAll(coref.getReferences().openSet(region));
		}
		if(refs.isEmpty())
			return null;
		
		// translate into refexp
		IHasPositionSet<IndexedRefExp> result = new HasPositionSet<IndexedRefExp>();
		IRefExp refexp;
		for(IReference ref : refs){
			refexp = new RefExp(ref.getSegments());
			result.add(new IndexedRefExp(refexp));
		}
		return result;
	}

}
