/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.helpers;

import edu.mit.parsing.ui.controllers.ISegmentSetController;
import edu.mit.parsing.ui.widgets.SegmentSetCaptureWidget;
import edu.mit.semantics.core.rep.timex3.ITimex3;
import edu.mit.semantics.core.rep.timex3.model.ITimex3Model;
import edu.mit.semantics.ui.controllers.ITimex3Controller;
import edu.mit.semantics.ui.controllers.Timex3Controller;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.label.NameLabelProvider;
import edu.mit.story.ui.widgets.AnnotationWidget;
import edu.mit.story.ui.widgets.ButtonAction;
import edu.mit.story.ui.widgets.MessageBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;

public class Timex3CreatorPage
extends HelperPage
implements ChangeListener,
ICreatorPage {
    public static final String ID = "edu.mit.semantics.ui.helpers.Timex3CreatorPage";
    public static String buttonLabelCommit = "Commit";
    public static String buttonLabelSave = "Save";
    public static String buttonLabelClear = "Clear";
    public static String buttonLabelCancel = "Cancel";
    public static String actionLabelCommit = "Commit Time Expression";
    public static String actionLabelSave = "Save Time Expression";
    public static String actionLabelClear = "Clear Time Expression";
    public static String actionLabelCancel = "Cancel Editing";
    public static IMessageProvider clearedMessage = new Message("Use this page to create a new time expression", 1);
    public static IMessageProvider createMessage = new Message("Press the 'commit' button to add this time expression to the story model", 1);
    public static IMessageProvider saveMessage = new Message("Press the 'save' button to change this time expression in the story model", 1);
    protected ITimex3Controller controller;
    protected MessageProviderManager messageManager;
    protected MessageBar messageBar;
    protected SegmentSetCaptureWidget<ITimex3Controller> expWidget;
    protected SegmentSetCaptureWidget<ISegmentSetController> quantWidget;
    protected SegmentSetCaptureWidget<ISegmentSetController> freqWidget;
    protected ComboViewer typeCombo;
    protected ComboViewer modCombo;
    protected ComboViewer funcCombo;
    protected Label quantLabel;
    protected Label freqLabel;
    protected Button commitButton;
    protected Button clearButton;
    protected ButtonAction commitAction;
    protected ButtonAction clearAction;

    public ITimex3Controller getController() {
        return this.controller;
    }

    public void createControl(Composite parent) {
        this.controller = new Timex3Controller("edu.mit.story.ui.annotation.target1", this.getStoryEditor(), "edu.mit.story.ui.annotation.target2", "edu.mit.story.ui.annotation.target3");
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        control.setLayout((Layout)layout);
        control.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        control.setForeground(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"));
        this.messageBar = new MessageBar(control, 0);
        this.messageBar.setLayoutData((Object)new GridData(4, 4, true, false));
        this.messageBar.setBackground(control.getBackground());
        this.messageBar.setForeground(control.getForeground());
        Label rule = new Label(control, 258);
        rule.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite inputParent = new Composite(control, 0);
        inputParent.setBackground(control.getBackground());
        inputParent.setForeground(control.getForeground());
        inputParent.setLayoutData((Object)new GridData(4, 0, true, false));
        inputParent.setLayout((Layout)new GridLayout(5, false));
        Label label = new Label(inputParent, 0);
        label.setBackground(inputParent.getBackground());
        label.setForeground(inputParent.getForeground());
        label.setText("Expression");
        this.expWidget = new SegmentSetCaptureWidget<ITimex3Controller>(inputParent, 65536, this.controller){

            protected void createLeadingControls(Composite parent) {
                GridLayout l = new GridLayout();
                l.marginWidth = 0;
                l.marginHeight = 0;
                l.horizontalSpacing = 0;
                parent.setLayout((Layout)l);
                Timex3CreatorPage.this.typeCombo = new ComboViewer(parent);
                Timex3CreatorPage.this.typeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
                Timex3CreatorPage.this.typeCombo.setLabelProvider((IBaseLabelProvider)NameLabelProvider.getInstance());
                Timex3CreatorPage.this.typeCombo.setInput((Object)ITimex3.Type.values());
                Timex3CreatorPage.this.typeCombo.getCombo().setVisibleItemCount(ITimex3.Type.values().length);
                Timex3CreatorPage.this.typeCombo.getControl().setBackground(parent.getBackground());
                Timex3CreatorPage.this.typeCombo.getControl().setForeground(parent.getForeground());
                Timex3CreatorPage.this.typeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        ITimex3.Type type = (ITimex3.Type)SelectionUtils.extractSingle((ISelection)event.getSelection(), ITimex3.Type.class);
                        ((ITimex3Controller)((AnnotationWidget)this).controller).setType(type);
                    }
                });
            }
        };
        this.expWidget.setLayoutData((Object)new GridData(4, 0, true, false, 4, 1));
        this.expWidget.getAddAction().setText("Add to Time Expression");
        this.expWidget.getAddAction().setToolTipText("Add to Time Expression");
        this.expWidget.getSubtractAction().setText("Subtract from Time Expression");
        this.expWidget.getSubtractAction().setToolTipText("Subtract from Time Expression");
        this.expWidget.getClearAction().setText("Clear Time Expression");
        this.expWidget.getClearAction().setToolTipText("Clear Time Expression");
        label = new Label(inputParent, 0);
        label.setBackground(inputParent.getBackground());
        label.setForeground(inputParent.getForeground());
        label = new Label(inputParent, 0);
        label.setBackground(inputParent.getBackground());
        label.setForeground(inputParent.getForeground());
        label.setText("Modifier");
        this.modCombo = new ComboViewer(inputParent);
        this.modCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.modCombo.setLabelProvider((IBaseLabelProvider)NameLabelProvider.getInstance());
        this.modCombo.setInput((Object)ITimex3.Mod.values());
        this.modCombo.getCombo().setVisibleItemCount(ITimex3.Mod.values().length);
        this.modCombo.getControl().setBackground(inputParent.getBackground());
        this.modCombo.getControl().setForeground(inputParent.getForeground());
        this.modCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITimex3.Mod mod = (ITimex3.Mod)SelectionUtils.extractSingle((ISelection)event.getSelection(), ITimex3.Mod.class);
                Timex3CreatorPage.this.controller.setModification(mod);
            }
        });
        label = new Label(inputParent, 0);
        label.setBackground(inputParent.getBackground());
        label.setForeground(inputParent.getForeground());
        label.setText("Function");
        this.funcCombo = new ComboViewer(inputParent);
        this.funcCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.funcCombo.setLabelProvider((IBaseLabelProvider)NameLabelProvider.getInstance());
        this.funcCombo.setInput((Object)ITimex3.Function.values());
        this.funcCombo.getCombo().setVisibleItemCount(ITimex3.Function.values().length);
        this.funcCombo.getControl().setBackground(inputParent.getBackground());
        this.funcCombo.getControl().setForeground(inputParent.getForeground());
        this.funcCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITimex3.Function func = (ITimex3.Function)SelectionUtils.extractSingle((ISelection)event.getSelection(), ITimex3.Function.class);
                Timex3CreatorPage.this.controller.setFunction(func);
            }
        });
        this.quantLabel = new Label(inputParent, 0);
        this.quantLabel.setBackground(inputParent.getBackground());
        this.quantLabel.setForeground(inputParent.getForeground());
        this.quantLabel.setText("Quantifier");
        this.quantWidget = new SegmentSetCaptureWidget(inputParent, 65536, this.controller.getQuantController());
        this.quantWidget.setLayoutData((Object)new GridData(4, 0, true, false, 4, 1));
        this.quantWidget.getAddAction().setText("Add to Quantification");
        this.quantWidget.getAddAction().setToolTipText("Add to Quantification");
        this.quantWidget.getSubtractAction().setText("Subtract from Quantification");
        this.quantWidget.getSubtractAction().setToolTipText("Subtract from Quantification");
        this.quantWidget.getClearAction().setText("Clear Quantification");
        this.quantWidget.getClearAction().setToolTipText("Clear Quantification");
        this.freqLabel = new Label(inputParent, 0);
        this.freqLabel.setBackground(inputParent.getBackground());
        this.freqLabel.setForeground(inputParent.getForeground());
        this.freqLabel.setText("Frequency");
        this.freqWidget = new SegmentSetCaptureWidget(inputParent, 65536, this.controller.getFreqController());
        this.freqWidget.setLayoutData((Object)new GridData(4, 0, true, false, 4, 1));
        this.freqWidget.getAddAction().setText("Add to Frequency");
        this.freqWidget.getAddAction().setToolTipText("Add to Frequency");
        this.freqWidget.getSubtractAction().setText("Subtract from Frequency");
        this.freqWidget.getSubtractAction().setToolTipText("Subtract from Frequency");
        this.freqWidget.getClearAction().setText("Clear Frequency");
        this.freqWidget.getClearAction().setToolTipText("Clear Frequency");
        Composite buttonParent = new Composite(inputParent, 0);
        buttonParent.setBackground(inputParent.getBackground());
        buttonParent.setForeground(inputParent.getForeground());
        buttonParent.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 5, 1));
        buttonParent.setLayout((Layout)new GridLayout(3, false));
        label = new Label(buttonParent, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setBackground(buttonParent.getBackground());
        label.setForeground(buttonParent.getForeground());
        this.commitButton = new Button(buttonParent, 0);
        this.commitButton.setText("Commit");
        this.commitAction = new ButtonAction(this.commitButton){

            public void run() {
                Timex3CreatorPage.this.controller.commit();
            }
        };
        this.clearButton = new Button(buttonParent, 0);
        this.clearButton.setText("Clear");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                Timex3CreatorPage.this.controller.clear();
            }
        };
        this.messageManager = new MessageProviderManager(createMessage, (ChangeListener)this);
        this.messageManager.setAllClearedMesage(clearedMessage);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getModel(), true);
        this.messageManager.addChangeListener((ChangeListener)this);
        this.updateFromModel();
    }

    protected void updateFromModel() {
        IMessageProvider defaultMsg;
        ITimex3Model timexModel = this.controller.getModel();
        boolean enableQuant = this.couldBeSet(timexModel.getType()) || timexModel.getQuantifier() != null;
        boolean enableFreq = this.couldBeSet(timexModel.getType()) || timexModel.getFrequency() != null;
        boolean enableCommit = !timexModel.isCleared() && timexModel.getMessageType() != 3;
        boolean enableClear = !timexModel.isCleared();
        StructuredSelection typeSel = new StructuredSelection((Object)timexModel.getType());
        StructuredSelection modSel = new StructuredSelection((Object)timexModel.getModifier());
        StructuredSelection funcSel = new StructuredSelection((Object)timexModel.getFunction());
        if (!this.typeCombo.getSelection().equals(typeSel)) {
            this.typeCombo.setSelection((ISelection)typeSel);
        }
        if (!this.modCombo.getSelection().equals(modSel)) {
            this.modCombo.setSelection((ISelection)modSel);
        }
        if (!this.funcCombo.getSelection().equals(funcSel)) {
            this.funcCombo.setSelection((ISelection)funcSel);
        }
        if (enableCommit != this.commitAction.isEnabled()) {
            this.commitAction.setEnabled(enableCommit);
        }
        if (enableClear != this.clearAction.isEnabled()) {
            this.clearAction.setEnabled(enableClear);
        }
        if (enableQuant != this.quantWidget.isEnabled()) {
            this.quantLabel.setEnabled(enableQuant);
            this.quantWidget.setEnabled(enableQuant);
        }
        if (enableFreq != this.freqWidget.isEnabled()) {
            this.freqLabel.setEnabled(enableFreq);
            this.freqWidget.setEnabled(enableFreq);
        }
        boolean isLoaded = timexModel.getLoaded() != null;
        String commitActionLabel = isLoaded ? actionLabelSave : actionLabelCommit;
        String clearActionLabel = isLoaded ? actionLabelCancel : actionLabelClear;
        String commitButtonLabel = isLoaded ? buttonLabelSave : buttonLabelCommit;
        String clearButtonLabel = isLoaded ? buttonLabelCancel : buttonLabelClear;
        boolean labelChanged = false;
        if (!commitActionLabel.equals(this.commitAction.getText())) {
            this.commitAction.setText(commitActionLabel);
            this.commitAction.setToolTipText(commitActionLabel);
        }
        if (!clearActionLabel.equals(this.clearAction.getText())) {
            this.clearAction.setText(clearActionLabel);
            this.clearAction.setToolTipText(clearActionLabel);
        }
        if (!commitButtonLabel.equals(this.commitButton.getText())) {
            labelChanged = true;
            this.commitButton.setText(commitButtonLabel);
        }
        if (!clearButtonLabel.equals(this.clearButton.getText())) {
            labelChanged = true;
            this.clearButton.setText(clearButtonLabel);
        }
        IMessageProvider iMessageProvider = defaultMsg = isLoaded ? saveMessage : createMessage;
        if (!this.messageManager.getDefaultMessage().equals(defaultMsg)) {
            this.messageManager.setDefaultMesage(defaultMsg);
        }
        this.messageBar.setMessage(this.messageManager.getMessage(), this.messageManager.getMessageType());
        if (labelChanged) {
            ((Composite)this.getControl()).layout(true, true);
        }
    }

    public boolean couldBeSet(ITimex3.Type type) {
        return type == ITimex3.Type.SET || type == ITimex3.Type.UNKNOWN || type == ITimex3.Type.UNSPECIFIED;
    }

    public void setActionBars(IActionBars actionBars) {
        this.expWidget.getAddAction().setActionDefinitionId("edu.mit.story.ui.commands.add.1");
        this.quantWidget.getAddAction().setActionDefinitionId("edu.mit.story.ui.commands.add.2");
        this.freqWidget.getAddAction().setActionDefinitionId("edu.mit.story.ui.commands.add.3");
        actionBars.setGlobalActionHandler(this.expWidget.getAddAction().getActionDefinitionId(), this.expWidget.getAddAction());
        actionBars.setGlobalActionHandler(this.quantWidget.getAddAction().getActionDefinitionId(), this.quantWidget.getAddAction());
        actionBars.setGlobalActionHandler(this.freqWidget.getAddAction().getActionDefinitionId(), this.freqWidget.getAddAction());
        this.expWidget.getSubtractAction().setActionDefinitionId("edu.mit.story.ui.commands.subtract.1");
        this.quantWidget.getSubtractAction().setActionDefinitionId("edu.mit.story.ui.commands.subtract.2");
        this.freqWidget.getSubtractAction().setActionDefinitionId("edu.mit.story.ui.commands.subtract.3");
        actionBars.setGlobalActionHandler(this.expWidget.getSubtractAction().getActionDefinitionId(), this.expWidget.getSubtractAction());
        actionBars.setGlobalActionHandler(this.quantWidget.getSubtractAction().getActionDefinitionId(), this.quantWidget.getSubtractAction());
        actionBars.setGlobalActionHandler(this.freqWidget.getSubtractAction().getActionDefinitionId(), this.freqWidget.getSubtractAction());
        this.expWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.1");
        this.quantWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.2");
        this.freqWidget.getClearAction().setActionDefinitionId("edu.mit.story.ui.commands.clear.3");
        this.clearAction.setActionDefinitionId("edu.mit.story.ui.commands.clear.0");
        actionBars.setGlobalActionHandler(this.expWidget.getClearAction().getActionDefinitionId(), this.expWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.quantWidget.getClearAction().getActionDefinitionId(), this.quantWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.freqWidget.getClearAction().getActionDefinitionId(), this.freqWidget.getClearAction());
        actionBars.setGlobalActionHandler(this.clearAction.getActionDefinitionId(), (IAction)this.clearAction);
        this.commitAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.0");
        actionBars.setGlobalActionHandler(this.commitAction.getActionDefinitionId(), (IAction)this.commitAction);
    }

    public void stateChanged(ChangeEvent event) {
        this.updateFromModel();
    }

    public void dispose() {
        super.dispose();
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
    }
}

