/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.helpers;

import edu.mit.discourse.ui.label.CorefDisplayText;
import edu.mit.semantics.core.rep.mentalstate.MentalStateRep;
import edu.mit.semantics.core.rep.mentalstate.model.IMentalStateModel;
import edu.mit.semantics.core.rep.valence.Valence;
import edu.mit.semantics.ui.controllers.IMentalStateController;
import edu.mit.semantics.ui.controllers.MentalStateController;
import edu.mit.semantics.ui.label.EventDisplayText;
import edu.mit.story.core.datamodel.IDescModel;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.util.IDescDisplayText;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.controllers.IDescController;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.label.NameLabelProvider;
import edu.mit.story.ui.util.ColorManager;
import edu.mit.story.ui.widgets.ButtonAction;
import edu.mit.story.ui.widgets.DescCaptureWidget;
import edu.mit.story.ui.widgets.MessageBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;

public class MentalStateCreatorPage
extends HelperPage
implements ICreatorPage,
IAdaptable {
    public static final String ID = MentalStateCreatorPage.class.getName();
    public static String buttonLabelCommit = "Commit";
    public static String buttonLabelSave = "Save";
    public static String buttonLabelClear = "Clear";
    public static String buttonLabelCancel = "Cancel";
    public static String buttonLabelCommitArg = "Commit Mental State";
    public static String buttonLabelSaveArg = "Save Mental State";
    public static String actionLabelCommit = "Commit Mental State";
    public static String actionLabelSave = "Save Mental State";
    public static String actionLabelClear = "Clear Mental State";
    public static String actionLabelCancel = "Cancel Edit";
    public static IMessageProvider clearedMessage = new Message("Use this page to create a new mental state", 1);
    public static IMessageProvider createMessage = new Message("Press the 'commit' button to add this mental state to the story model", 1);
    public static IMessageProvider saveMessage = new Message("Press the 'save' button to change this mental state in the story model", 1);
    protected IMentalStateController controller;
    protected IModelListener modelListener = new IModelListener(){

        public void modelChanged(StoryChangeEvent e) {
            if (MentalStateCreatorPage.this.getControl().isDisposed()) {
                return;
            }
            if (e.affects(MentalStateRep.getInstance())) {
                MentalStateCreatorPage.this.updateFromModel();
            }
        }
    };
    protected MessageBar messageBar;
    protected MessageProviderManager messageManager;
    protected ComboViewer valenceCombo;
    protected DescCaptureWidget<IDescController<IDescModel>> eventWidget;
    protected DescCaptureWidget<IDescController<IDescModel>> charWidget;
    protected Button commitButton;
    protected Button clearButton;
    protected ButtonAction commitAction;
    protected ButtonAction clearAction;

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)MentalStateCreatorPage.zeroMargins((GridLayout)new GridLayout()));
        control.setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        control.setForeground(StoryUIPlugin.getDefault().getColorManager().get((Object)"BLACK"));
        this.setControl((Control)control);
        this.controller = new MentalStateController(this.getStoryEditor(), "edu.mit.story.ui.annotation.target1", "edu.mit.story.ui.annotation.target2");
        this.getStoryEditor().getStoryModel().addModelListener(this.modelListener);
        this.messageManager = new MessageProviderManager();
        this.messageManager.setAllClearedMesage(clearedMessage);
        this.messageManager.add((INotifyingMessageProvider)this.controller.getModel());
        this.messageManager.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MentalStateCreatorPage.this.updateFromModel();
            }
        });
        this.messageBar = new MessageBar(control, 0);
        this.messageBar.setLayoutData((Object)new GridData(4, 4, true, false));
        ColorManager.inheritColors((Control)this.messageBar);
        Label rule = new Label(control, 258);
        rule.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite widgets = new Composite(control, 0);
        widgets.setLayoutData((Object)new GridData(4, 128, true, false));
        widgets.setBackground(control.getBackground());
        widgets.setForeground(control.getForeground());
        widgets.setLayout((Layout)new GridLayout(2, false));
        this.createCaptureWidgets(widgets);
        this.createControlCommit(widgets);
        this.updateFromModel();
    }

    protected void createCaptureWidgets(Composite parent) {
        Label label = new Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setText("Valence");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.valenceCombo = new ComboViewer(parent);
        this.valenceCombo.getControl().setLayoutData((Object)new GridData(0, 0, false, false));
        ColorManager.inheritColors((Control)this.valenceCombo.getControl());
        this.valenceCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.valenceCombo.setLabelProvider((IBaseLabelProvider)NameLabelProvider.getInstance());
        this.valenceCombo.setInput((Object)Valence.values());
        this.valenceCombo.getCombo().setVisibleItemCount(Valence.values().length);
        this.valenceCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Valence sel = (Valence)SelectionUtils.extractSingle((ISelection)event.getSelection(), Valence.class);
                MentalStateCreatorPage.this.controller.setValence(sel);
            }
        });
        label = new Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setText("Event");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.eventWidget = new DescCaptureWidget(parent, 0, this.controller.getEventController(), (IDescDisplayText)EventDisplayText.getInstance());
        this.eventWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.eventWidget.getCaptureAction().setText("Capture Event");
        this.eventWidget.getCaptureAction().setToolTipText("Capture Event");
        this.eventWidget.getClearAction().setText("Clear Event");
        this.eventWidget.getClearAction().setToolTipText("Clear Event");
        label = new Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setText("Character");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.charWidget = new DescCaptureWidget(parent, 0, this.controller.getCharacterController(), (IDescDisplayText)CorefDisplayText.getInstance());
        this.charWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.charWidget.getCaptureAction().setText("Capture Character");
        this.charWidget.getCaptureAction().setToolTipText("Capture Character");
        this.charWidget.getClearAction().setText("Clear Character");
        this.charWidget.getClearAction().setToolTipText("Clear Character");
    }

    protected void createControlCommit(Composite parent) {
        Label label = new Label(parent, 0);
        ColorManager.inheritColors((Control)label);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        Composite buttons = new Composite(parent, 0);
        ColorManager.inheritColors((Control)buttons);
        buttons.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        buttons.setLayout((Layout)MentalStateCreatorPage.zeroMargins((GridLayout)new GridLayout(3, false)));
        label = new Label(buttons, 0);
        label.setBackground(buttons.getBackground());
        label.setForeground(buttons.getForeground());
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.commitButton = new Button(buttons, 0);
        this.commitButton.setText("Commit");
        this.commitAction = new ButtonAction(this.commitButton){

            public void run() {
                MentalStateCreatorPage.this.controller.commit();
            }
        };
        this.clearButton = new Button(buttons, 0);
        this.clearButton.setText("Clear");
        this.clearAction = new ButtonAction(this.clearButton){

            public void run() {
                MentalStateCreatorPage.this.controller.clear();
            }
        };
    }

    public void setActionBars(IActionBars actionBars) {
        this.eventWidget.getCaptureAction().setActionDefinitionId("edu.mit.story.ui.commands.add.1");
        actionBars.setGlobalActionHandler(this.eventWidget.getCaptureAction().getActionDefinitionId(), this.eventWidget.getCaptureAction());
        this.charWidget.getCaptureAction().setActionDefinitionId("edu.mit.story.ui.commands.add.2");
        actionBars.setGlobalActionHandler(this.charWidget.getCaptureAction().getActionDefinitionId(), this.charWidget.getCaptureAction());
        this.commitAction.setActionDefinitionId("edu.mit.story.ui.commands.commit.0");
        actionBars.setGlobalActionHandler(this.commitAction.getActionDefinitionId(), (IAction)this.commitAction);
        this.clearAction.setActionDefinitionId("edu.mit.story.ui.commands.clear.0");
        actionBars.setGlobalActionHandler(this.clearAction.getActionDefinitionId(), (IAction)this.clearAction);
    }

    protected void updateFromModel() {
        String clearActionLabel;
        IMessageProvider defaultMsg;
        IMentalStateModel stateModel = this.controller.getModel();
        boolean isMainLoaded = stateModel.getLoaded() != null;
        IMessageProvider iMessageProvider = defaultMsg = isMainLoaded ? saveMessage : createMessage;
        if (!this.messageManager.getDefaultMessage().equals(defaultMsg)) {
            this.messageManager.setDefaultMesage(defaultMsg);
        }
        this.messageBar.setMessage(this.messageManager.getMessage(), this.messageManager.getMessageType());
        boolean enableCommit = !stateModel.isCleared() && this.messageManager.getMessageType() != 3;
        boolean enableClear = !stateModel.isCleared() || !stateModel.isCleared();
        String commitButtonLabel = isMainLoaded ? buttonLabelSave : buttonLabelCommit;
        String clearButtonLabel = isMainLoaded ? buttonLabelCancel : buttonLabelClear;
        String commitActionLabel = isMainLoaded ? actionLabelSave : actionLabelCommit;
        String string = clearActionLabel = isMainLoaded ? actionLabelCancel : actionLabelClear;
        if (enableCommit != this.commitButton.isEnabled()) {
            this.commitButton.setEnabled(enableCommit);
        }
        if (enableClear != this.clearButton.isEnabled()) {
            this.clearButton.setEnabled(enableClear);
        }
        StructuredSelection valenceSel = new StructuredSelection((Object)stateModel.getValence());
        if (!this.valenceCombo.getSelection().equals(valenceSel)) {
            this.valenceCombo.setSelection((ISelection)valenceSel);
        }
        if (!commitActionLabel.equals(this.commitAction.getText())) {
            this.commitAction.setText(commitActionLabel);
            this.commitAction.setToolTipText(commitActionLabel);
        }
        if (!clearActionLabel.equals(this.clearAction.getText())) {
            this.clearAction.setText(clearActionLabel);
            this.clearAction.setToolTipText(clearActionLabel);
        }
        boolean labelChanged = false;
        if (!commitButtonLabel.equals(this.commitButton.getText())) {
            labelChanged = true;
            this.commitButton.setText(commitButtonLabel);
        }
        if (!clearButtonLabel.equals(this.clearButton.getText())) {
            labelChanged = true;
            this.clearButton.setText(clearButtonLabel);
        }
        if (labelChanged) {
            ((Composite)this.getControl()).layout(true, true);
        }
    }

    public IMentalStateController getController() {
        return this.controller;
    }

    public void dispose() {
        super.dispose();
        this.getStoryEditor().getStoryModel().removeModelListener(this.modelListener);
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

