/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.actions;

import edu.mit.semantics.core.rep.event.Aspect;
import edu.mit.semantics.core.rep.event.Event;
import edu.mit.semantics.core.rep.event.EventClass;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.event.POS;
import edu.mit.semantics.core.rep.event.Tense;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.ActionGroup;

public class ChangeEventFeatureActionGroup
extends ActionGroup {
    private IMenuManager classMenu;
    private IMenuManager posMenu;
    private IMenuManager tenseMenu;
    private IMenuManager aspectMenu;
    private IMenuManager polarityMenu;

    public ChangeEventFeatureActionGroup(IStoryEditor editor, ISelectionProvider provider) {
        this(editor, provider, true);
    }

    public ChangeEventFeatureActionGroup(IStoryEditor editor, ISelectionProvider provider, boolean allMenus) {
        this.createActions(editor, provider, allMenus);
    }

    public IRep getRep() {
        return EventRep.getInstance();
    }

    protected void createActions(IStoryEditor editor, ISelectionProvider provider, boolean allMenus) {
        this.classMenu = new MenuManager("&Class");
        this.classMenu.setRemoveAllWhenShown(true);
        this.classMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EventClass[] eventClassArray = EventClass.values();
                int n = eventClassArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EventClass f = eventClassArray[n2];
                    manager.add((IAction)new ChangeClassAction(f, editor, provider));
                    ++n2;
                }
            }
        });
        if (!allMenus) {
            return;
        }
        this.posMenu = new MenuManager("Part of &Speech");
        this.posMenu.setRemoveAllWhenShown(true);
        this.posMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                POS[] pOSArray = POS.values();
                int n = pOSArray.length;
                int n2 = 0;
                while (n2 < n) {
                    POS f = pOSArray[n2];
                    manager.add((IAction)new ChangePOSAction(f, editor, provider));
                    ++n2;
                }
            }
        });
        this.tenseMenu = new MenuManager("&Tense");
        this.tenseMenu.setRemoveAllWhenShown(true);
        this.tenseMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Tense[] tenseArray = Tense.values();
                int n = tenseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Tense f = tenseArray[n2];
                    manager.add((IAction)new ChangeTenseAction(f, editor, provider));
                    ++n2;
                }
            }
        });
        this.aspectMenu = new MenuManager("&Aspect");
        this.aspectMenu.setRemoveAllWhenShown(true);
        this.aspectMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Aspect[] aspectArray = Aspect.values();
                int n = aspectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Aspect f = aspectArray[n2];
                    manager.add((IAction)new ChangeAspectAction(f, editor, provider));
                    ++n2;
                }
            }
        });
        this.polarityMenu = new MenuManager("&Polarity");
        this.polarityMenu.setRemoveAllWhenShown(true);
        this.polarityMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new ChangePolarityAction(true, editor, provider));
                manager.add((IAction)new ChangePolarityAction(false, editor, provider));
            }
        });
    }

    protected static String extractName(Object obj) {
        StringBuilder sb = new StringBuilder();
        if (obj instanceof IHasName) {
            sb.append(((IHasName)obj).getName());
        } else {
            sb.append(obj.toString());
        }
        sb.insert(0, '&');
        return sb.toString();
    }

    public void fillContextMenu(IMenuManager menu) {
        Object element = SelectionUtils.extractSingle((ISelection)this.getContext().getSelection(), Object.class);
        Object obj = element;
        if (obj instanceof IDesc) {
            IDesc d = (IDesc)obj;
            if (this.getRep().isType((IHasRep)d)) {
                obj = d.getData();
            }
        }
        boolean all = obj instanceof IEvent;
        StoryEditorContentProvider.Element child = null;
        if (obj instanceof StoryEditorContentProvider.Element) {
            child = (StoryEditorContentProvider.Element)obj;
            obj = child.getElement();
        }
        if (all || obj instanceof EventClass) {
            menu.appendToGroup("additions", (IContributionItem)this.classMenu);
        }
        if ((all || obj instanceof POS) && this.posMenu != null) {
            menu.appendToGroup("additions", (IContributionItem)this.posMenu);
        }
        if ((all || obj instanceof Tense) && this.tenseMenu != null) {
            menu.appendToGroup("additions", (IContributionItem)this.tenseMenu);
        }
        if ((all || obj instanceof Aspect) && this.aspectMenu != null) {
            menu.appendToGroup("additions", (IContributionItem)this.aspectMenu);
        }
        if ((all || child != null && child.getType() == 3) && this.polarityMenu != null) {
            menu.appendToGroup("additions", (IContributionItem)this.polarityMenu);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeAspectAction
    extends ChangeEventFeatureAction<Aspect> {
        public ChangeAspectAction(Aspect feature, IStoryEditor editor, ISelectionProvider provider) {
            super(feature, editor, provider);
        }

        @Override
        protected boolean isChecked(IEvent e) {
            return e.getAspect() == this.getFeature();
        }

        @Override
        protected IEvent createEvent(IEvent oldEvent) {
            return new Event(oldEvent.getEventClass(), oldEvent.getEventTokens(), oldEvent.getHeadTokens(), oldEvent.getPOS(), oldEvent.getTense(), (Aspect)this.getFeature(), oldEvent.getPolarity(), oldEvent.getPolarityTokens(), oldEvent.getCardinality(), oldEvent.getCardinalityTokens(), oldEvent.getModalityTokens());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeClassAction
    extends ChangeEventFeatureAction<EventClass> {
        public ChangeClassAction(EventClass feature, IStoryEditor editor, ISelectionProvider provider) {
            super(feature, editor, provider);
        }

        @Override
        protected boolean isChecked(IEvent e) {
            return e.getEventClass() == this.getFeature();
        }

        @Override
        protected IEvent createEvent(IEvent oldEvent) {
            return new Event((EventClass)this.getFeature(), oldEvent.getEventTokens(), oldEvent.getHeadTokens(), oldEvent.getPOS(), oldEvent.getTense(), oldEvent.getAspect(), oldEvent.getPolarity(), oldEvent.getPolarityTokens(), oldEvent.getCardinality(), oldEvent.getCardinalityTokens(), oldEvent.getModalityTokens());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ChangeEventFeatureAction<F>
    extends Action {
        private F feature;
        private IStoryEditor editor;
        private ISelectionProvider provider;

        public ChangeEventFeatureAction(F feature, IStoryEditor editor, ISelectionProvider provider) {
            super(ChangeEventFeatureActionGroup.extractName(feature), 2);
            if (feature == null) {
                throw new NullPointerException();
            }
            if (editor == null) {
                throw new NullPointerException();
            }
            if (provider == null) {
                throw new NullPointerException();
            }
            this.feature = feature;
            this.editor = editor;
            this.provider = provider;
        }

        public F getFeature() {
            return this.feature;
        }

        protected IDesc getTargetDesc() {
            Object element = SelectionUtils.extractSingle((ISelection)this.provider.getSelection(), Object.class);
            if (element instanceof StoryEditorContentProvider.Element) {
                StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
                element = child.getParent();
            }
            if (element instanceof IDesc) {
                IDesc d = (IDesc)element;
                if (ChangeEventFeatureActionGroup.this.getRep().isType((IHasRep)d)) {
                    return d;
                }
            }
            return null;
        }

        public boolean isChecked() {
            Object element = SelectionUtils.extractSingle((ISelection)this.provider.getSelection(), Object.class);
            if (element instanceof StoryEditorContentProvider.Element) {
                StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
                element = child.getParent();
            }
            if (element instanceof IDesc) {
                IDesc d = (IDesc)element;
                element = d.getData();
            }
            if (element instanceof IEvent) {
                return this.isChecked((IEvent)element);
            }
            return false;
        }

        protected abstract boolean isChecked(IEvent var1);

        public void run() {
            IDesc oldDesc = this.getTargetDesc();
            if (oldDesc == null) {
                throw new IllegalStateException("no description on which to work");
            }
            IEvent newEvent = this.createEvent((IEvent)oldDesc.getData());
            Desc newDesc = new Desc(oldDesc.getID(), oldDesc.getRep(), newEvent.calculatePosition(), (IData)newEvent, null);
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)Origin.USER_SPECIFIED));
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)new Timing(((Object)((Object)this)).getClass().getCanonicalName(), true)));
            RemoveDescriptionsChange change = new RemoveDescriptionsChange(oldDesc);
            change = new CompositeModelChange(new IModelChange[]{change, new AddDescriptionsChange((IDesc)newDesc)});
            this.editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        }

        protected abstract IEvent createEvent(IEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangePOSAction
    extends ChangeEventFeatureAction<POS> {
        public ChangePOSAction(POS feature, IStoryEditor editor, ISelectionProvider provider) {
            super(feature, editor, provider);
        }

        @Override
        protected boolean isChecked(IEvent e) {
            return e.getPOS() == this.getFeature();
        }

        @Override
        protected IEvent createEvent(IEvent oldEvent) {
            return new Event(oldEvent.getEventClass(), oldEvent.getEventTokens(), oldEvent.getHeadTokens(), (POS)this.getFeature(), oldEvent.getTense(), oldEvent.getAspect(), oldEvent.getPolarity(), oldEvent.getPolarityTokens(), oldEvent.getCardinality(), oldEvent.getCardinalityTokens(), oldEvent.getModalityTokens());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangePolarityAction
    extends ChangeEventFeatureAction<Boolean> {
        public ChangePolarityAction(Boolean feature, IStoryEditor editor, ISelectionProvider provider) {
            super(feature, editor, provider);
        }

        @Override
        protected boolean isChecked(IEvent e) {
            return e.getPolarity() == ((Boolean)this.getFeature()).booleanValue();
        }

        @Override
        protected IEvent createEvent(IEvent oldEvent) {
            return new Event(oldEvent.getEventClass(), oldEvent.getEventTokens(), oldEvent.getHeadTokens(), oldEvent.getPOS(), oldEvent.getTense(), oldEvent.getAspect(), ((Boolean)this.getFeature()).booleanValue(), oldEvent.getPolarityTokens(), oldEvent.getCardinality(), oldEvent.getCardinalityTokens(), oldEvent.getModalityTokens());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeTenseAction
    extends ChangeEventFeatureAction<Tense> {
        public ChangeTenseAction(Tense feature, IStoryEditor editor, ISelectionProvider provider) {
            super(feature, editor, provider);
        }

        @Override
        protected boolean isChecked(IEvent e) {
            return e.getTense() == this.getFeature();
        }

        @Override
        protected IEvent createEvent(IEvent oldEvent) {
            return new Event(oldEvent.getEventClass(), oldEvent.getEventTokens(), oldEvent.getHeadTokens(), oldEvent.getPOS(), (Tense)this.getFeature(), oldEvent.getAspect(), oldEvent.getPolarity(), oldEvent.getPolarityTokens(), oldEvent.getCardinality(), oldEvent.getCardinalityTokens(), oldEvent.getModalityTokens());
        }
    }
}

