/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.util.StringUtils;
import java.io.PrintStream;
import java.util.Properties;

public class TaggerConfig {
    private String model;
    private String file;
    private String method;
    private String lang;
    private String arch;
    private String debugPrefix;
    private String tokenizerFactory;
    private String delimiter;
    private boolean debug;
    private boolean tokenize;
    private int iterations;

    public TaggerConfig(String[] args) {
        Properties props = StringUtils.argsToProperties(args);
        if (!props.getProperty("").equals("")) {
            throw new RuntimeException("unknown argument(s): \"" + props.getProperty("") + "\"");
        }
        if (props.getProperty("genprops") != null) {
            System.out.println("## sample properties file for maxent tagger. this file is used for three");
            System.out.println("## operations: training, testing, and tagging.");
            System.out.println("## to training a model, run:");
            System.out.println("##   java edu.stanford.nlp.tagger.maxent.Train -prop <properties file>");
            System.out.println("## to test it, run:");
            System.out.println("##   java edu.stanford.nlp.tagger.maxent.Test -prop <properties file>");
            System.out.println("## to tag something, run:");
            System.out.println("##   java edu.stanford.nlp.tagger.maxent.MaxentTagger -prop <properties file>");
            System.out.println("## arguments can be overridden on the commandline, e.g.:");
            System.out.println("##   java ....Train -prop <properties file> -file /other/file ");
            System.out.println("");
            System.out.println("# prefix for model files (created at train time; used at tag and test time)");
            System.out.println("# (you can leave this blank and specify it on the commandline with -model)");
            System.out.println("# model = ");
            System.out.println("");
            System.out.println("# path to file to be operated on (trained from, tested against, or tagged)");
            System.out.println("# (you can leave this blank and specify it on the commandline with -file)");
            System.out.println("# file = ");
            System.out.println("");
            System.out.println("# delimiter that separates word and pos tags (for both training and test");
            System.out.println("# data).");
            System.out.println("# delimiter = _");
            System.out.println("");
            System.out.println("######### parameters for tag and test operations #########");
            System.out.println("");
            System.out.println("# class to use for tokenization. default blank value means Penn Treebank tokenization.");
            System.out.println("# tokenizerFactory = ");
            System.out.println("");
            System.out.println("# whether to tokenize text for tag and test operations. default is true. if false,");
            System.out.println("# your text must already be whitespace tokenized.");
            System.out.println("# tokenize = true");
            System.out.println("");
            System.out.println("# write debugging information (words, top words, unknown words). useful for error");
            System.out.println("# analysis. default false.");
            System.out.println("# debug = false");
            System.out.println("");
            System.out.println("# prefix for debugging output (if debug == true). default is to use the filename from 'file'");
            System.out.println("# debugPrefix = ");
            System.out.println("");
            System.out.println("######### parameters for training  #########");
            System.out.println("");
            System.out.println("# model architecture: 'left3words', 'bidirectional', or 'sighan2005'");
            System.out.println("arch = ");
            System.out.println("");
            System.out.println("# search method. 'cg' (conjugate gradient (default)) or 'iis' (improved iterative scaling)");
            System.out.println("# method = cg");
            System.out.println("");
            System.out.println("# language (for list of open-class tags): 'english' or 'polish'");
            System.out.println("lang = ");
            System.out.println("");
            System.out.println("# magic number  do not change!!1");
            System.out.println("# iterations = 100");
            System.exit(0);
        }
        this.model = props.getProperty("model", "");
        if (this.model.trim().equals("")) {
            throw new RuntimeException("'model' parameter must be specified");
        }
        this.file = props.getProperty("file", "");
        if (this.file.trim().equals("")) {
            throw new RuntimeException("'file' parameter must be specified");
        }
        this.method = props.getProperty("method", "cg");
        if (!this.method.equalsIgnoreCase("cg") && !this.method.equalsIgnoreCase("iis")) {
            throw new RuntimeException("'method' must be one of 'cg' or 'iis': " + this.method);
        }
        this.delimiter = props.getProperty("delimiter", "_");
        this.iterations = Integer.parseInt(props.getProperty("iterations", "100"));
        this.lang = props.getProperty("lang", "");
        this.arch = props.getProperty("arch", "");
        this.debugPrefix = props.getProperty("debugPrefix", "");
        this.debug = Boolean.parseBoolean(props.getProperty("debug", "false"));
        this.tokenize = Boolean.parseBoolean(props.getProperty("tokenize", "true"));
        this.tokenizerFactory = props.getProperty("tokenizerFactory", "");
    }

    public String getModel() {
        return this.model;
    }

    public String getFile() {
        return this.file;
    }

    public String getMethod() {
        return this.method;
    }

    public int getIterations() {
        return this.iterations;
    }

    public String getLang() {
        return this.lang;
    }

    public String getArch() {
        return this.arch;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public String getDebugPrefix() {
        return this.debugPrefix;
    }

    public String getTokenizerFactory() {
        return this.tokenizerFactory;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public boolean getTokenize() {
        return this.tokenize;
    }

    public void dump() {
        this.dump(System.err);
    }

    public void dump(PrintStream stream) {
        stream.println("           model = " + this.model);
        stream.println("            file = " + this.file);
        stream.println("          method = " + this.method);
        stream.println("      iterations = " + this.iterations);
        stream.println("            lang = " + this.lang);
        stream.println("            arch = " + this.arch);
        stream.println("           debug = " + this.debug);
        stream.println("     debugPrefix = " + this.debugPrefix);
        stream.println("        tokenize = " + this.tokenize);
        stream.println("tokenizerFactory = " + this.tokenizerFactory);
    }
}

