/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.FA;
import edu.stanford.nlp.util.Numberer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OutsideRuleFilter {
    private Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
    private Numberer stateNumberer = Numberer.getGlobalNumberer("states");
    private int numTags;
    private int numFAs;
    protected FA[] leftFA;
    protected FA[] rightFA;

    protected static <A> List<A> reverse(List<A> list) {
        int sz = list.size();
        ArrayList<A> reverse = new ArrayList<A>(sz);
        for (int i = sz - 1; i >= 0; --i) {
            reverse.add(list.get(i));
        }
        return reverse;
    }

    protected FA buildFA(List tags) {
        FA fa = new FA(tags.size() + 1, this.numTags);
        fa.setLoopState(0, true);
        for (int state = 1; state <= tags.size(); ++state) {
            Object tagO = tags.get(state - 1);
            if (tagO == null) {
                fa.setLoopState(state, true);
                for (int symbol = 0; symbol < this.numTags; ++symbol) {
                    fa.setTransition(state - 1, symbol, state);
                }
                continue;
            }
            int tag = this.tagNumberer.number(tagO);
            fa.setTransition(state - 1, tag, state);
        }
        return fa;
    }

    protected void registerRule(List leftTags, List rightTags, int state) {
        this.leftFA[state] = this.buildFA(leftTags);
        this.rightFA[state] = this.buildFA(OutsideRuleFilter.reverse(rightTags));
    }

    public void init() {
        for (int rule = 0; rule < this.numFAs; ++rule) {
            this.leftFA[rule].init();
            this.rightFA[rule].init();
        }
    }

    public void advanceRight(boolean[] tags) {
        for (int tag = 0; tag < this.numTags; ++tag) {
            if (!tags[tag]) continue;
            for (int rule = 0; rule < this.numFAs; ++rule) {
                this.leftFA[rule].input(tag);
            }
        }
        for (int rule = 0; rule < this.numFAs; ++rule) {
            this.leftFA[rule].advance();
        }
    }

    public void leftAccepting(boolean[] result) {
        for (int rule = 0; rule < this.numFAs; ++rule) {
            result[rule] = this.leftFA[rule].isAccepting();
        }
    }

    public void advanceLeft(boolean[] tags) {
        for (int tag = 0; tag < this.numTags; ++tag) {
            if (!tags[tag]) continue;
            for (int rule = 0; rule < this.numFAs; ++rule) {
                this.rightFA[rule].input(tag);
            }
        }
        for (int rule = 0; rule < this.numFAs; ++rule) {
            this.rightFA[rule].advance();
        }
    }

    public void rightAccepting(boolean[] result) {
        for (int rule = 0; rule < this.numFAs; ++rule) {
            result[rule] = this.rightFA[rule].isAccepting();
        }
    }

    private void allocate(int numFAs) {
        this.numFAs = numFAs;
        this.leftFA = new FA[numFAs];
        this.rightFA = new FA[numFAs];
    }

    public OutsideRuleFilter(BinaryGrammar bg) {
        int numStates = this.stateNumberer.total();
        this.numTags = this.tagNumberer.total();
        this.allocate(numStates);
        for (int state = 0; state < numStates; ++state) {
            String stateStr = (String)this.stateNumberer.object(state);
            ArrayList<String> left = new ArrayList<String>();
            ArrayList right = new ArrayList();
            if (!bg.isSynthetic(state)) {
                this.registerRule(left, right, state);
                continue;
            }
            boolean foundSemi = false;
            boolean foundDots = false;
            ArrayList<String> array = left;
            StringBuilder sb = new StringBuilder();
            for (int c = 0; c < stateStr.length(); ++c) {
                if (stateStr.charAt(c) == ':') {
                    foundSemi = true;
                    continue;
                }
                if (!foundSemi) continue;
                if (stateStr.charAt(c) == ' ') {
                    if (sb.length() <= 0) continue;
                    String str = sb.toString();
                    if (!this.tagNumberer.hasSeen(str)) {
                        str = null;
                    }
                    array.add(str);
                    sb = new StringBuilder();
                    continue;
                }
                if (!foundDots && stateStr.charAt(c) == '.') {
                    c += 3;
                    foundDots = true;
                    array = right;
                    continue;
                }
                sb.append(stateStr.charAt(c));
            }
            this.registerRule(left, right, state);
        }
    }
}

