/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.ops;

import edu.mit.story.core.agreement.IAgreementResult;
import edu.mit.story.core.datamodel.IStoryPairModel;
import edu.mit.story.core.datamodel.StoryPairModel;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.core.util.StringUtils;
import edu.mit.story.ui.ops.CalculateAgreementOperation;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculateAgreementOperationBatch
extends WorkspaceModifyOperation {
    private final String srcName;
    private final String tgtName;
    private final Map<IFile, IFile> filePairs;
    private final IRepSet reps;

    public CalculateAgreementOperationBatch(String srcName, String tgtName, Map<IFile, IFile> filePairs, Set<IRep> reps) {
        if (srcName == null) {
            throw new NullPointerException();
        }
        if (tgtName == null) {
            throw new NullPointerException();
        }
        if (filePairs.containsKey(null)) {
            throw new NullPointerException();
        }
        if (filePairs.containsValue(null)) {
            throw new NullPointerException();
        }
        srcName = srcName.trim();
        tgtName = tgtName.trim();
        if (srcName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (tgtName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (reps.isEmpty()) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap<IFile, IFile> ps = new LinkedHashMap<IFile, IFile>(filePairs);
        RepSet rs = new RepSet(reps);
        this.filePairs = ps;
        this.reps = rs;
        this.srcName = srcName;
        this.tgtName = tgtName;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        final LinkedHashMap<String, List<IAgreementResult>> resultMap = new LinkedHashMap<String, List<IAgreementResult>>();
        monitor.beginTask("Calculating agreement...", this.filePairs.size());
        for (Map.Entry<IFile, IFile> pair : this.filePairs.entrySet()) {
            IStoryPairModel model = this.getStoryModels(pair.getKey(), pair.getValue());
            final String name = pair.getKey().getName();
            CalculateAgreementOperation op = new CalculateAgreementOperation(name, this.srcName, this.tgtName, model.getSourceModel(), model.getTargetModel(), (Set)this.reps){

                @Override
                protected void reportResults(List<IAgreementResult> results) {
                    resultMap.put(name, results);
                }
            };
            op.execute((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            monitor.worked(1);
        }
        monitor.done();
        this.reportResults(resultMap);
    }

    protected void reportResults(Map<String, List<IAgreementResult>> resultMap) {
        for (Map.Entry<String, List<IAgreementResult>> e : resultMap.entrySet()) {
            System.out.println(e.getKey());
            for (IAgreementResult result : e.getValue()) {
                System.out.println(StringUtils.indent((String)"\t", (String)result.toString()));
            }
        }
    }

    protected IStoryPairModel getStoryModels(IFile source, IFile target) {
        StoryPairModel model = new StoryPairModel();
        model.setSource(source == null ? null : source.getRawLocation().toFile());
        model.setTarget(target == null ? null : target.getRawLocation().toFile());
        return model;
    }
}

