/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep.character;

import edu.mit.story.core.align.Aligner;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.character.IAlignedText;
import edu.mit.story.core.rep.character.IOffset;
import edu.mit.story.core.util.Debug;
import gnu.trove.decorator.TIntIntMapDecorator;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.AbstractList;
import java.util.List;
import org.eclipse.jface.text.ITextStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignedText
extends AbstractList<Aligner.Pair<IOffset, IOffset>>
implements IAlignedText {
    private final ITextStore source;
    private final ITextStore target;
    private final TIntIntMapDecorator offsets;
    private final TIntIntMapDecorator rightOffsets;
    private final List<Aligner.Pair<IOffset, IOffset>> alignment;

    public AlignedText(ITextStore source, ITextStore target, List<Aligner.Pair<IOffset, IOffset>> alignment) {
        if (source == null) {
            throw new NullPointerException();
        }
        if (target == null) {
            throw new NullPointerException();
        }
        if (alignment == null) {
            throw new NullPointerException();
        }
        this.source = source;
        this.target = target;
        this.offsets = new TIntIntMapDecorator((TIntIntMap)new TIntIntHashMap(source.getLength() + 1));
        this.rightOffsets = new TIntIntMapDecorator((TIntIntMap)new TIntIntHashMap(target.getLength() + 1));
        this.alignment = alignment;
        AlignedText.fillMaps(alignment, this.offsets, this.rightOffsets);
    }

    @Override
    public ITextStore getSource() {
        return this.source;
    }

    @Override
    public ITextStore getTarget() {
        return this.target;
    }

    @Override
    public int getOffset(int srcOffset) {
        return this.offsets.getMap().get(srcOffset);
    }

    @Override
    public int getRightOffset(int srcOffset) {
        return this.rightOffsets.getMap().get(srcOffset);
    }

    @Override
    public Aligner.Pair<IOffset, IOffset> get(int index) {
        return this.alignment.get(index);
    }

    @Override
    public int size() {
        return this.alignment.size();
    }

    public static void fillMaps(List<Aligner.Pair<IOffset, IOffset>> align, TIntIntMapDecorator offs, TIntIntMapDecorator roffs) {
        int lastLeft = 0;
        for (Aligner.Pair<IOffset, IOffset> pair : align) {
            if (pair.a == null || pair.b == null) continue;
            int currLeft = ((IOffset)pair.a).getOffset();
            offs.getMap().put(currLeft, ((IOffset)pair.b).getOffset());
            roffs.getMap().put(currLeft + 1, ((IOffset)pair.b).getOffset() + 1);
            if (currLeft == 0) {
                roffs.getMap().put(currLeft, ((IOffset)pair.b).getOffset());
            }
            while (lastLeft < currLeft) {
                offs.getMap().put(lastLeft, ((IOffset)pair.b).getOffset());
                roffs.getMap().put(lastLeft + 1, ((IOffset)pair.b).getOffset());
                ++lastLeft;
            }
            lastLeft = currLeft + 1;
        }
    }

    public static void main(String[] args) {
        String one = "abcxdxeaaxyzaaa";
        String two = "xabxcdeaamnpaaa";
        ITextStore source = (ITextStore)CharRep.getInstance().reconstitute(new SimplePosition(0, one.length()), one, null);
        ITextStore target = (ITextStore)CharRep.getInstance().reconstitute(new SimplePosition(0, two.length()), two, null);
        IAlignedText alignment = CharRep.align(source, target);
        StringBuilder sb = new StringBuilder();
        sb.append("\n   ");
        for (Aligner.Pair pair : alignment) {
            if (pair.b != null) {
                sb.append(((IOffset)pair.b).getOffset());
                sb.append(((IOffset)pair.b).getOffset() < 10 ? " " : "");
                continue;
            }
            sb.append("  ");
        }
        sb.append("\ntgt");
        sb.append('|');
        for (Aligner.Pair pair : alignment) {
            sb.append(pair.b == null ? (char)'_' : ((IOffset)pair.b).getChar());
            sb.append('|');
        }
        sb.append("\nsrc");
        sb.append('|');
        for (Aligner.Pair pair : alignment) {
            sb.append(pair.a == null ? (char)'_' : ((IOffset)pair.a).getChar());
            sb.append('|');
        }
        sb.append("\n   ");
        for (Aligner.Pair pair : alignment) {
            if (pair.a != null) {
                sb.append(((IOffset)pair.a).getOffset());
                sb.append(((IOffset)pair.a).getOffset() < 10 ? " " : "");
                continue;
            }
            sb.append("  ");
        }
        Debug.out(sb);
    }
}

