/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.descriptor;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.descriptor.Descriptor;
import edu.mit.story.core.descriptor.ICreatableDescriptor;
import edu.mit.story.core.util.LogUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatableDescriptor<C>
extends Descriptor
implements ICreatableDescriptor<C> {
    private final String attrName;
    private final IConfigurationElement element;
    private Class<? extends C> clazz;

    public CreatableDescriptor(IConfigurationElement e) {
        this(e, "class");
    }

    public CreatableDescriptor(IConfigurationElement e, String attrName) {
        this(CreatableDescriptor.extractID(e), CreatableDescriptor.extractName(e), CreatableDescriptor.extractDesc(e), e, attrName);
    }

    public CreatableDescriptor(String id, String name, String desc, IConfigurationElement e, String attrName) {
        super(id, name, desc);
        if (e == null) {
            throw new NullPointerException();
        }
        if (attrName.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.element = e;
        this.attrName = attrName;
    }

    @Override
    public String getClassAttribute() {
        return this.attrName;
    }

    @Override
    public Class<? extends C> getCreatableClass() {
        return this.clazz;
    }

    @Override
    public C create() {
        String attr = this.element.getAttribute(this.attrName);
        if (attr == null) {
            return null;
        }
        try {
            Object result = this.element.createExecutableExtension(this.attrName);
            if (this.clazz == null) {
                this.clazz = result.getClass();
            }
            return (C)result;
        }
        catch (ClassCastException e) {
            LogUtils.logError((Plugin)StoryPlugin.getDefault(), e);
            return null;
        }
        catch (CoreException e) {
            String message = "There was an error while trying to instantiate an object of id=" + this.getID();
            Status status = new Status(4, StoryPlugin.getDefault().getID(), message, (Throwable)e);
            StoryPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    @Override
    public IConfigurationElement getConfigurationElement() {
        return this.element;
    }

    public static String extractID(IConfigurationElement e) {
        return e.getAttribute("id");
    }

    public static String extractName(IConfigurationElement e) {
        return e.getAttribute("name");
    }

    public static String extractDesc(IConfigurationElement e) {
        return e.getAttribute("description");
    }
}

