/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.viewers;

import edu.mit.parsing.core.rep.parse.ITree;
import edu.mit.parsing.ui.operations.ParseTreeDeleteOperation;
import edu.mit.parsing.ui.operations.ParseTreeInsertOperation;
import edu.mit.parsing.ui.operations.ParseTreeMoveOperation;
import edu.mit.parsing.ui.operations.ParseTreeRenameOperation;
import edu.mit.parsing.ui.viewers.ParseTreeSelectableViewer;
import edu.mit.story.core.util.Debug;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.swt.widgets.Composite;

public class ParseTreeEclipse
extends ParseTreeSelectableViewer {
    IOperationHistory operationHistory;
    IUndoContext undoContext;

    public ParseTreeEclipse(Composite parent, int style, IOperationHistory history, IUndoContext context) {
        super(parent, style);
        this.operationHistory = history;
        this.undoContext = context;
    }

    public boolean insert(ITree target, ITree child, int targetIndex, boolean pushSideways) {
        ParseTreeInsertOperation operation = new ParseTreeInsertOperation(this, target, child, targetIndex, pushSideways);
        operation.addContext(this.undoContext);
        try {
            this.operationHistory.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return operation.getResult();
    }

    public boolean move(ITree target, ITree child, int targetIndex) {
        ParseTreeMoveOperation operation = new ParseTreeMoveOperation(this, target, child, targetIndex);
        Debug.out((String)("Using undo context: " + this.undoContext));
        operation.addContext(this.undoContext);
        try {
            this.operationHistory.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return operation.getResult();
    }

    public int delete(ITree node) {
        ParseTreeDeleteOperation operation = new ParseTreeDeleteOperation(this, node);
        operation.addContext(this.undoContext);
        try {
            this.operationHistory.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return operation.getResult();
    }

    public boolean rename(ITree target, String newName) {
        ParseTreeRenameOperation operation = new ParseTreeRenameOperation(this, target, newName);
        operation.addContext(this.undoContext);
        try {
            this.operationHistory.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return operation.getResult();
    }

    public boolean callbackInsert(ITree parent, ITree child, int index, boolean pushSideways) {
        return super.insert(parent, child, index, pushSideways);
    }

    public boolean callbackMove(ITree target, ITree node, int index) {
        return super.move(target, node, index);
    }

    public int callbackDelete(ITree node) {
        return super.delete(node);
    }

    public boolean callbackRename(ITree node, String newName) {
        return super.rename(node, newName);
    }
}

