/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi;

import edu.mit.jwi.DictionaryClosedException;
import edu.mit.jwi.IDataSourceDictionary;
import edu.mit.jwi.ItemCache;
import edu.mit.jwi.StringMatcher;
import edu.mit.jwi.data.ContentType;
import edu.mit.jwi.data.FileProvider;
import edu.mit.jwi.data.IContentType;
import edu.mit.jwi.data.IDataProvider;
import edu.mit.jwi.data.IDataSource;
import edu.mit.jwi.data.parse.ILineParser;
import edu.mit.jwi.item.ExceptionEntry;
import edu.mit.jwi.item.ExceptionEntryID;
import edu.mit.jwi.item.IExceptionEntry;
import edu.mit.jwi.item.IExceptionEntryID;
import edu.mit.jwi.item.IExceptionEntryProxy;
import edu.mit.jwi.item.IHasPOS;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IIndexWordID;
import edu.mit.jwi.item.ISenseEntry;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IVersion;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.IndexWordID;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Pointer;
import edu.mit.jwi.item.Synset;
import edu.mit.jwi.item.SynsetID;
import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dictionary
implements IDataSourceDictionary {
    private final ItemCache fCache = this.createCache();
    private IDataProvider fDataProvider = null;

    public Dictionary(URL url) {
        this(new FileProvider(url));
    }

    public Dictionary(IDataProvider provider) {
        if (provider == null) {
            throw new NullPointerException();
        }
        this.setDataProvider(provider);
    }

    @Override
    public boolean setDataProvider(IDataProvider provider) {
        if (provider == null || this.isOpen()) {
            return false;
        }
        this.fDataProvider = provider;
        return true;
    }

    @Override
    public IDataProvider getDataProvider() {
        return this.fDataProvider;
    }

    @Override
    public IVersion getVersion() {
        this.checkOpen();
        return this.fDataProvider.getVersion();
    }

    @Override
    public boolean open() {
        try {
            this.fDataProvider.open();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getCache().init();
        return true;
    }

    @Override
    public void close() {
        this.getCache().clear();
        this.fDataProvider.close();
    }

    @Override
    public boolean isOpen() {
        if (this.fDataProvider == null) {
            return false;
        }
        return this.fDataProvider.isOpen();
    }

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new DictionaryClosedException();
        }
    }

    protected ItemCache createCache() {
        return new ItemCache();
    }

    public ItemCache getCache() {
        return this.fCache;
    }

    @Override
    public IIndexWord getIndexWord(String lemma, POS pos) {
        this.checkOpen();
        return this.getIndexWord(new IndexWordID(lemma, pos));
    }

    @Override
    public IIndexWord getIndexWord(IIndexWordID id) {
        this.checkOpen();
        if (id == null) {
            return null;
        }
        IIndexWord result = this.getCache().retrieveIndexWord(id);
        if (result == null) {
            IContentType<IIndexWord> content = this.resolveIndexContentType(id.getPOS());
            IDataSource<IIndexWord> file = this.fDataProvider.getSource(content);
            String line = file.getLine(id.getLemma());
            if (line == null) {
                return null;
            }
            result = content.getDataType().getParser().parseLine(line);
            this.getCache().cacheIndexWord(result);
        }
        return result;
    }

    @Override
    public IWord getWord(IWordID id) {
        this.checkOpen();
        if (id == null) {
            return null;
        }
        IWord result = this.getCache().retrieveWord(id);
        if (result == null) {
            ISynset synset = this.getSynset(id.getSynsetID());
            if (synset == null) {
                return null;
            }
            if (id.getSenseNumber() > 0) {
                result = synset.getWords().get(id.getSenseNumber() - 1);
            } else if (id.getLemma() != null) {
                for (IWord word : synset.getWords()) {
                    if (!word.getLemma().equalsIgnoreCase(id.getLemma())) continue;
                    result = word;
                    break;
                }
            } else {
                throw new IllegalArgumentException("Not enough information in IWordID instance to retrieve word.");
            }
        }
        return result;
    }

    @Override
    public IWord getWord(ISenseKey key) {
        IIndexWord indexWord;
        ISynset synset;
        this.checkOpen();
        if (key == null) {
            return null;
        }
        IWord word = this.getCache().retrieveWord(key);
        if (word != null) {
            return word;
        }
        ISenseEntry entry = this.getSenseEntry(key);
        if (entry != null && (synset = this.getSynset(new SynsetID(entry.getOffset(), entry.getPOS()))) != null) {
            for (IWord synonym : synset.getWords()) {
                if (!synonym.getSenseKey().equals(key)) continue;
                return synonym;
            }
        }
        if (word == null && (indexWord = this.getIndexWord(key.getLemma(), key.getPOS())) != null) {
            for (IWordID wordID : indexWord.getWordIDs()) {
                IWord possibleWord = this.getWord(wordID);
                for (IWord synonym : possibleWord.getSynset().getWords()) {
                    if (!synonym.getSenseKey().equals(key)) continue;
                    word = synonym;
                    if (!synonym.getLemma().equals(key.getLemma())) continue;
                    return synonym;
                }
            }
        }
        return word;
    }

    @Override
    public ISenseEntry getSenseEntry(ISenseKey key) {
        this.checkOpen();
        if (key == null) {
            return null;
        }
        ISenseEntry entry = this.getCache().retrieveSenseEntry(key);
        if (entry == null) {
            IContentType<ISenseEntry> content = this.resolveSenseContentType();
            IDataSource<ISenseEntry> file = this.fDataProvider.getSource(content);
            String line = file.getLine(key.toString());
            if (line == null) {
                return null;
            }
            entry = content.getDataType().getParser().parseLine(line);
            if (entry == null) {
                return null;
            }
            this.getCache().cacheSenseEntry(entry);
        }
        return entry;
    }

    @Override
    public ISynset getSynset(ISynsetID id) {
        this.checkOpen();
        if (id == null) {
            return null;
        }
        ISynset result = this.getCache().retrieveSynset(id);
        if (result == null) {
            String zeroFilledOffset;
            IContentType<ISynset> content = this.resolveDataContentType(id.getPOS());
            IDataSource<ISynset> file = this.fDataProvider.getSource(content);
            String line = file.getLine(zeroFilledOffset = Synset.zeroFillOffset(id.getOffset()));
            if (line == null) {
                return null;
            }
            result = content.getDataType().getParser().parseLine(line);
            if (result == null) {
                return null;
            }
            this.setHeadWord(result);
            this.getCache().cacheSynset(result);
            for (IWord word : result.getWords()) {
                this.getCache().cacheWord(word);
            }
        }
        return result;
    }

    protected void setHeadWord(ISynset synset) {
        boolean isVer16;
        if (!synset.isAdjectiveSatellite()) {
            return;
        }
        IWord headWord = null;
        for (ISynsetID simID : synset.getRelatedSynsets(Pointer.SIMILAR_TO)) {
            ISynset headSynset = this.getSynset(simID);
            if (!headSynset.isAdjectiveHead()) continue;
            headWord = headSynset.getWords().get(0);
            break;
        }
        if (headWord == null) {
            return;
        }
        String headLemma = headWord.getLemma();
        IVersion ver = this.getVersion();
        boolean bl = ver == null ? false : (isVer16 = ver.getMajorVersion() == 1 && ver.getMinorVersion() == 6);
        if (isVer16 && headWord.getAdjectiveMarker() != null) {
            headLemma = headLemma + headWord.getAdjectiveMarker().getSymbol();
        }
        for (IWord word : synset.getWords()) {
            if (!word.getSenseKey().needsHeadSet()) continue;
            word.getSenseKey().setHead(headLemma, headWord.getLexicalID());
        }
    }

    @Override
    public IExceptionEntry getExceptionEntry(String surfaceForm, POS pos) {
        return this.getExceptionEntry(new ExceptionEntryID(surfaceForm, pos));
    }

    @Override
    public IExceptionEntry getExceptionEntry(IExceptionEntryID id) {
        this.checkOpen();
        if (id == null) {
            return null;
        }
        IExceptionEntry result = this.getCache().retrieveExceptionEntry(id);
        if (result == null) {
            IContentType<IExceptionEntryProxy> content = this.resolveExceptionContentType(id.getPOS());
            IDataSource<IExceptionEntryProxy> file = this.fDataProvider.getSource(content);
            if (file == null) {
                return null;
            }
            String line = file.getLine(id.getSurfaceForm());
            if (line == null) {
                return null;
            }
            IExceptionEntryProxy proxy = content.getDataType().getParser().parseLine(line);
            if (proxy != null) {
                result = new ExceptionEntry(proxy, id.getPOS());
                this.getCache().cacheExceptionEntry(result);
            }
        }
        return result;
    }

    protected IContentType<IIndexWord> resolveIndexContentType(POS pos) {
        return ContentType.getIndexContentType(pos);
    }

    protected IContentType<ISynset> resolveDataContentType(POS pos) {
        return ContentType.getDataContentType(pos);
    }

    protected IContentType<IExceptionEntryProxy> resolveExceptionContentType(POS pos) {
        return ContentType.getExceptionContentType(pos);
    }

    protected IContentType<ISenseEntry> resolveSenseContentType() {
        return ContentType.SENSE;
    }

    @Override
    public Iterator<IIndexWord> getIndexWordIterator(POS pos) {
        this.checkOpen();
        return new IndexFileIterator(pos);
    }

    @Override
    public Iterator<IIndexWord> getIndexWordPatternIterator(POS pos, String pattern) {
        this.checkOpen();
        return new IndexFilePatternIterator(pos, pattern);
    }

    @Override
    public Iterator<ISynset> getSynsetIterator(POS pos) {
        this.checkOpen();
        return new DataFileIterator(pos);
    }

    @Override
    public Iterator<IExceptionEntry> getExceptionEntryIterator(POS pos) {
        this.checkOpen();
        return new ExceptionFileIterator(pos);
    }

    @Override
    public Iterator<ISenseEntry> getSenseEntryIterator() {
        this.checkOpen();
        return new SenseEntryFileIterator();
    }

    public static String getPatternRoot(String pattern, boolean ignoreWildCards) {
        if (!ignoreWildCards) {
            int idxS;
            int idxQ = pattern.indexOf(63);
            if (idxQ == -1) {
                idxQ = pattern.length();
            }
            if ((idxS = pattern.indexOf(42)) == -1) {
                idxS = pattern.length();
            }
            int idx = Math.min(idxQ, idxS);
            return pattern.substring(0, idx);
        }
        return pattern;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExceptionFileIterator
    extends FileIterator<IExceptionEntryProxy, IExceptionEntry> {
        public ExceptionFileIterator(POS pos) {
            super(Dictionary.this.resolveExceptionContentType(pos));
        }

        @Override
        public IExceptionEntry parseLine(String line) {
            IExceptionEntryProxy proxy = (IExceptionEntryProxy)this.fParser.parseLine(line);
            return proxy == null ? null : new ExceptionEntry(proxy, this.getPOS());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DataFileIterator
    extends FileIterator2<ISynset> {
        public DataFileIterator(POS pos) {
            super(Dictionary.this.resolveDataContentType(pos));
        }

        @Override
        public ISynset parseLine(String line) {
            if (this.getPOS() == POS.ADJECTIVE) {
                ISynset synset = (ISynset)this.fParser.parseLine(line);
                Dictionary.this.setHeadWord(synset);
                return synset;
            }
            return (ISynset)this.fParser.parseLine(line);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SenseEntryFileIterator
    extends FileIterator2<ISenseEntry> {
        public SenseEntryFileIterator() {
            super(Dictionary.this.resolveSenseContentType());
        }

        @Override
        public ISenseEntry parseLine(String line) {
            return (ISenseEntry)this.fParser.parseLine(line);
        }
    }

    public class IndexFilePatternIterator
    extends IndexFileIterator {
        IIndexWord previous;
        IIndexWord next;
        StringMatcher matcher;
        Comparator<String> fComparator;
        String fPatternRoot;

        public IndexFilePatternIterator(POS pos, String pattern) {
            super(pos, Dictionary.getPatternRoot(pattern, false));
            this.matcher = null;
            if (pattern == null) {
                throw new IllegalArgumentException("Pattern cannot be null in IndexFilePatterIterator");
            }
            this.matcher = new StringMatcher(pattern, true, false);
            this.fPatternRoot = this.matcher.getPatternRoot();
            this.fComparator = this.fFile.getContentType().getLineComparator();
            this.advance();
        }

        protected void advance() {
            do {
                String string = this.currentLine = this.iterator.hasNext() ? (String)this.iterator.next() : null;
                if (this.currentLine == null) {
                    this.next = null;
                    return;
                }
                this.next = this.parseLine(this.currentLine);
                if (this.next == null) break;
                if (this.next.getLemma().startsWith(this.fPatternRoot)) continue;
                this.next = null;
                break;
            } while (!this.matcher.match(this.next.getLemma()));
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public IIndexWord next() {
            this.previous = this.next;
            this.advance();
            return this.previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IndexFileIterator
    extends FileIterator2<IIndexWord> {
        public IndexFileIterator(POS pos) {
            this(pos, "");
        }

        public IndexFileIterator(POS pos, String pattern) {
            super(Dictionary.this.resolveIndexContentType(pos), pattern);
        }

        @Override
        public IIndexWord parseLine(String line) {
            return (IIndexWord)this.fParser.parseLine(line);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class FileIterator2<T>
    extends FileIterator<T, T> {
        public FileIterator2(IContentType<T> content) {
            super(content);
        }

        public FileIterator2(IContentType<T> content, String startKey) {
            super(content, startKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class FileIterator<T, N>
    implements Iterator<N>,
    IHasPOS {
        protected final IDataSource<T> fFile;
        protected final Iterator<String> iterator;
        protected final ILineParser<T> fParser;
        protected String currentLine;

        public FileIterator(IContentType<T> content) {
            this(content, null);
        }

        public FileIterator(IContentType<T> content, String startKey) {
            this.fFile = Dictionary.this.fDataProvider.getSource(content);
            this.fParser = content.getDataType().getParser();
            this.iterator = this.fFile.iterator(startKey);
        }

        @Override
        public POS getPOS() {
            return this.fFile.getContentType().getPOS();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public N next() {
            this.currentLine = this.iterator.next();
            return this.parseLine(this.currentLine);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        public abstract N parseLine(String var1);
    }
}

