/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.comments.CommitCommentArea;

public class CommitSetDialog
extends TrayDialog {
    private static final int DEFAULT_WIDTH_IN_CHARS = 80;
    private final ActiveChangeSet set;
    private CommitCommentArea commitCommentArea;
    private Text nameText;
    private Button useTitleButton;
    private Button enterCommentButton;
    private final String title;
    private final String description;
    private String comment;

    public CommitSetDialog(Shell parentShell, ActiveChangeSet set, IResource[] files, String title, String description) {
        this(parentShell, set, files, title, description, false);
    }

    public CommitSetDialog(Shell parentShell, ActiveChangeSet set, IResource[] files, String title, String description, boolean modeLess) {
        super(parentShell);
        if (modeLess) {
            this.setShellStyle(2144);
            this.setBlockOnOpen(false);
        }
        this.set = set;
        this.title = title;
        this.description = description;
        if (files == null) {
            files = set.getResources();
        }
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10 | 0x400);
        this.commitCommentArea = new CommitCommentArea((Dialog)this, this.getDialogBoundsSettings());
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createWrappingLabel(composite, this.description);
        this.createNameArea(composite);
        if (this.hasCommitTemplate()) {
            if (this.set.hasComment()) {
                this.comment = this.set.getComment();
                this.commitCommentArea.setProposedComment(this.comment);
            }
        } else {
            this.comment = this.set.getComment();
            this.commitCommentArea.setProposedComment(this.comment);
            this.createOptionsArea(composite);
        }
        this.commitCommentArea.createArea(composite);
        this.commitCommentArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "OkRequested") {
                    CommitSetDialog.this.okPressed();
                } else if (event.getProperty() == "CommentModified") {
                    CommitSetDialog.this.comment = (String)event.getNewValue();
                    CommitSetDialog.this.updateEnablements();
                }
            }
        });
        this.initializeValues();
        this.updateEnablements();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.commit_set_dialog_context");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.x = this.convertWidthInCharsToPixels(80);
        size.y += this.convertHeightInCharsToPixels(8);
        return size;
    }

    private void createNameArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(Policy.bind("CommitSetDialog_0"));
        label.setLayoutData((Object)new GridData(1));
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommitSetDialog.this.updateEnablements();
            }
        });
    }

    private void initializeValues() {
        String initialText = this.set.getTitle();
        if (initialText == null) {
            initialText = "";
        }
        this.nameText.setText(initialText);
        if (this.useTitleButton != null) {
            this.useTitleButton.setSelection(!this.set.hasComment());
            this.enterCommentButton.setSelection(this.set.hasComment());
        }
    }

    private void createOptionsArea(Composite composite) {
        Composite radioArea = new Composite(composite, 0);
        RowLayout radioAreaLayout = new RowLayout(512);
        radioAreaLayout.marginLeft = 0;
        radioAreaLayout.marginRight = 0;
        radioAreaLayout.marginTop = 0;
        radioAreaLayout.marginBottom = 0;
        radioArea.setLayout((Layout)radioAreaLayout);
        this.useTitleButton = this.createRadioButton(radioArea, Policy.bind("CommitSetDialog_2"));
        this.enterCommentButton = this.createRadioButton(radioArea, Policy.bind("CommitSetDialog_3"));
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitSetDialog.this.updateEnablements();
            }
        };
        this.useTitleButton.addSelectionListener((SelectionListener)listener);
        this.enterCommentButton.addSelectionListener((SelectionListener)listener);
    }

    private Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16);
        button.setText(label);
        return button;
    }

    private void updateEnablements() {
        this.commitCommentArea.setEnabled(this.isUseCustomComment());
        String name = this.nameText.getText();
        if (name.length() == 0) {
            this.setPageComplete(false);
            return;
        }
        if (this.isUseCustomComment() && (this.comment == null || this.comment.length() == 0)) {
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }

    protected final void setPageComplete(boolean complete) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(complete);
        }
    }

    private boolean hasCommitTemplate() {
        return this.commitCommentArea.hasCommitTemplate();
    }

    protected void okPressed() {
        this.set.setTitle(this.nameText.getText());
        if (this.isUseCustomComment()) {
            this.set.setComment(this.commitCommentArea.getComment(true));
        } else {
            this.set.setComment(null);
        }
        super.okPressed();
    }

    private boolean isUseCustomComment() {
        return this.enterCommentButton == null || this.enterCommentButton.getSelection();
    }

    protected Label createWrappingLabel(Composite parent, String text) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.horizontalIndent = 0;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 200;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.updateEnablements();
        return control;
    }
}

