/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.navigator.NavigatorActivationService;
import org.eclipse.ui.internal.navigator.NavigatorContentServiceContentProvider;
import org.eclipse.ui.internal.navigator.NavigatorContentServiceDescriptionProvider;
import org.eclipse.ui.internal.navigator.NavigatorContentServiceLabelProvider;
import org.eclipse.ui.internal.navigator.NavigatorExtensionStateService;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.internal.navigator.NavigatorPipelineService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.NavigatorSaveablesService;
import org.eclipse.ui.internal.navigator.VisibilityAssistant;
import org.eclipse.ui.internal.navigator.dnd.NavigatorDnDService;
import org.eclipse.ui.internal.navigator.extensions.ExtensionPriorityComparator;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptorManager;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.internal.navigator.extensions.NavigatorViewerDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorViewerDescriptorManager;
import org.eclipse.ui.internal.navigator.extensions.StructuredViewerManager;
import org.eclipse.ui.internal.navigator.sorters.NavigatorSorterService;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.eclipse.ui.navigator.IExtensionActivationListener;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.IMementoAware;
import org.eclipse.ui.navigator.INavigatorActivationService;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorContentServiceListener;
import org.eclipse.ui.navigator.INavigatorDnDService;
import org.eclipse.ui.navigator.INavigatorFilterService;
import org.eclipse.ui.navigator.INavigatorPipelineService;
import org.eclipse.ui.navigator.INavigatorSaveablesService;
import org.eclipse.ui.navigator.INavigatorSorterService;
import org.eclipse.ui.navigator.INavigatorViewerDescriptor;

public class NavigatorContentService
implements IExtensionActivationListener,
IMementoAware,
INavigatorContentService {
    private static final NavigatorContentDescriptorManager CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorManager.getInstance();
    private static final NavigatorViewerDescriptorManager VIEWER_DESCRIPTOR_REGISTRY = NavigatorViewerDescriptorManager.getInstance();
    private static final ITreeContentProvider[] NO_CONTENT_PROVIDERS = new ITreeContentProvider[0];
    private static final ILabelProvider[] NO_LABEL_PROVIDERS = new ILabelProvider[0];
    private static final INavigatorContentDescriptor[] NO_DESCRIPTORS = new INavigatorContentDescriptor[0];
    private static final String[] NO_EXTENSION_IDS = new String[0];
    private final NavigatorViewerDescriptor viewerDescriptor;
    private final List listeners = new ArrayList();
    private final Map contentExtensions = new HashMap();
    private StructuredViewerManager structuredViewerManager;
    private ITreeContentProvider[] rootContentProviders;
    private WeakHashMap contributionMemory;
    private ITreeContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private final VisibilityAssistant assistant;
    private NavigatorFilterService navigatorFilterService;
    private INavigatorSorterService navigatorSorterService;
    private INavigatorPipelineService navigatorPipelineService;
    private INavigatorDnDService navigatorDnDService;
    private INavigatorActivationService navigatorActivationService;
    private NavigatorSaveablesService navigatorSaveablesService;
    private NavigatorExtensionStateService navigatorExtensionStateService;
    private IDescriptionProvider descriptionProvider;
    private boolean contentProviderInitialized;
    private boolean labelProviderInitialized;

    public NavigatorContentService(String aViewerId) {
        aViewerId = aViewerId != null ? aViewerId : "";
        this.viewerDescriptor = VIEWER_DESCRIPTOR_REGISTRY.getNavigatorViewerDescriptor(aViewerId);
        this.assistant = new VisibilityAssistant(this.viewerDescriptor, this.getActivationService());
        this.getActivationService().addExtensionActivationListener(this);
    }

    public NavigatorContentService(String aViewerId, StructuredViewer aViewer) {
        this(aViewerId);
        this.structuredViewerManager = new StructuredViewerManager((Viewer)aViewer);
    }

    public String[] getVisibleExtensionIds() {
        ArrayList<String> visibleExtensionIds = new ArrayList<String>();
        NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            if (this.assistant.isVisible(descriptors[i].getId())) {
                visibleExtensionIds.add(descriptors[i].getId());
            }
            ++i;
        }
        if (visibleExtensionIds.isEmpty()) {
            return NO_EXTENSION_IDS;
        }
        return visibleExtensionIds.toArray(new String[visibleExtensionIds.size()]);
    }

    public INavigatorContentDescriptor[] getVisibleExtensions() {
        ArrayList<NavigatorContentDescriptor> visibleDescriptors = new ArrayList<NavigatorContentDescriptor>();
        NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            if (this.assistant.isVisible(descriptors[i].getId())) {
                visibleDescriptors.add(descriptors[i]);
            }
            ++i;
        }
        if (visibleDescriptors.isEmpty()) {
            return NO_DESCRIPTORS;
        }
        return visibleDescriptors.toArray(new INavigatorContentDescriptor[visibleDescriptors.size()]);
    }

    INavigatorContentDescriptor[] getActiveDescriptorsWithSaveables() {
        ArrayList<NavigatorContentDescriptor> result = new ArrayList<NavigatorContentDescriptor>();
        NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptorsWithSaveables();
        int i = 0;
        while (i < descriptors.length) {
            if (this.assistant.isVisible(descriptors[i].getId()) && this.assistant.isActive(descriptors[i])) {
                result.add(descriptors[i]);
            }
            ++i;
        }
        if (result.isEmpty()) {
            return NO_DESCRIPTORS;
        }
        return result.toArray(new INavigatorContentDescriptor[result.size()]);
    }

    public INavigatorContentDescriptor[] bindExtensions(String[] extensionIds, boolean isRoot) {
        if (extensionIds == null || extensionIds.length == 0) {
            return NO_DESCRIPTORS;
        }
        int i = 0;
        while (i < extensionIds.length) {
            this.assistant.bindExtensions(extensionIds, isRoot);
            ++i;
        }
        HashSet<NavigatorContentDescriptor> boundDescriptors = new HashSet<NavigatorContentDescriptor>();
        int i2 = 0;
        while (i2 < extensionIds.length) {
            NavigatorContentDescriptor descriptor = CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(extensionIds[i2]);
            if (descriptor != null) {
                boundDescriptors.add(descriptor);
            }
            ++i2;
        }
        if (boundDescriptors.size() == 0) {
            return NO_DESCRIPTORS;
        }
        return boundDescriptors.toArray(new INavigatorContentDescriptor[boundDescriptors.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITreeContentProvider createCommonContentProvider() {
        if (this.contentProviderInitialized) {
            return this.contentProvider;
        }
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            if (this.contentProvider == null) {
                this.contentProvider = new NavigatorContentServiceContentProvider(this);
            }
            this.contentProviderInitialized = true;
        }
        return this.contentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILabelProvider createCommonLabelProvider() {
        if (this.labelProviderInitialized) {
            return this.labelProvider;
        }
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            if (this.labelProvider == null) {
                this.labelProvider = new NavigatorContentServiceLabelProvider(this);
            }
            this.labelProviderInitialized = true;
        }
        return this.labelProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDescriptionProvider createCommonDescriptionProvider() {
        if (this.descriptionProvider != null) {
            return this.descriptionProvider;
        }
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            if (this.descriptionProvider == null) {
                this.descriptionProvider = new NavigatorContentServiceDescriptionProvider(this);
            }
        }
        return this.descriptionProvider;
    }

    public void dispose() {
        if (this.navigatorSaveablesService != null) {
            this.assistant.removeListener(this.navigatorSaveablesService);
        }
        Iterator contentItr = this.contentExtensions.values().iterator();
        while (contentItr.hasNext()) {
            ((NavigatorContentExtension)contentItr.next()).dispose();
        }
        this.getActivationService().removeExtensionActivationListener(this);
        this.assistant.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateService(Viewer aViewer, Object anOldInput, Object aNewInput) {
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            if (this.structuredViewerManager == null) {
                this.structuredViewerManager = new StructuredViewerManager(aViewer);
                this.structuredViewerManager.inputChanged(anOldInput, aNewInput);
            } else {
                this.structuredViewerManager.inputChanged(aViewer, anOldInput, aNewInput);
            }
            Iterator contentItr = this.contentExtensions.values().iterator();
            while (contentItr.hasNext()) {
                NavigatorContentExtension ext = (NavigatorContentExtension)contentItr.next();
                if (!ext.isLoaded()) continue;
                this.structuredViewerManager.initialize((IStructuredContentProvider)ext.getContentProvider());
            }
            this.rootContentProviders = this.extractContentProviders(this.findRootContentExtensions(aNewInput));
        }
    }

    public IExtensionStateModel findStateModel(String anExtensionId) {
        if (anExtensionId == null) {
            return null;
        }
        NavigatorContentDescriptor desc = CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(anExtensionId);
        if (desc == null) {
            return null;
        }
        NavigatorContentExtension ext = this.getExtension(desc);
        if (ext == null) {
            return null;
        }
        return ext.getStateModel();
    }

    public ITreeContentProvider[] findParentContentProviders(Object anElement) {
        return this.extractContentProviders(this.findContentExtensionsWithPossibleChild(anElement));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITreeContentProvider[] findRootContentProviders(Object anElement) {
        if (this.rootContentProviders != null) {
            return this.rootContentProviders;
        }
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            if (this.rootContentProviders == null) {
                this.rootContentProviders = this.extractContentProviders(this.findRootContentExtensions(anElement));
            }
        }
        return this.rootContentProviders;
    }

    public ILabelProvider[] findRelevantLabelProviders(Object anElement) {
        return this.extractLabelProviders(this.findContentExtensionsWithPossibleChild(anElement, false));
    }

    public Set findRootContentExtensions(Object anElement) {
        return this.findRootContentExtensions(anElement, true);
    }

    public Set findRootContentExtensions(Object anElement, boolean toRespectViewerRoots) {
        TreeSet<NavigatorContentExtension> rootExtensions = new TreeSet<NavigatorContentExtension>(ExtensionPriorityComparator.INSTANCE);
        if (toRespectViewerRoots && this.viewerDescriptor.hasOverriddenRootExtensions()) {
            NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
            NavigatorContentExtension extension = null;
            int i = 0;
            while (i < descriptors.length) {
                if (this.isActive(descriptors[i].getId()) && this.isRootExtension(descriptors[i].getId()) && !(extension = this.getExtension(descriptors[i])).hasLoadingFailed()) {
                    rootExtensions.add(extension);
                }
                ++i;
            }
        }
        if (rootExtensions.isEmpty()) {
            return this.findContentExtensionsByTriggerPoint(anElement);
        }
        return rootExtensions;
    }

    public Set findOverrideableContentExtensionsByTriggerPoint(Object anElement) {
        TreeSet<NavigatorContentExtension> overrideableExtensions = new TreeSet<NavigatorContentExtension>(ExtensionPriorityComparator.INSTANCE);
        Set descriptors = this.findDescriptorsByTriggerPoint(anElement);
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            INavigatorContentDescriptor descriptor = (INavigatorContentDescriptor)iter.next();
            if (!descriptor.hasOverridingExtensions()) continue;
            overrideableExtensions.add(this.getExtension(descriptor));
        }
        return overrideableExtensions;
    }

    public Set findOverrideableContentExtensionsForPossibleChild(Object anElement) {
        TreeSet<NavigatorContentExtension> overrideableExtensions = new TreeSet<NavigatorContentExtension>(ExtensionPriorityComparator.INSTANCE);
        Set descriptors = this.findDescriptorsWithPossibleChild(anElement, false);
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            INavigatorContentDescriptor descriptor = (INavigatorContentDescriptor)iter.next();
            if (!descriptor.hasOverridingExtensions()) continue;
            overrideableExtensions.add(this.getExtension(descriptor));
        }
        return overrideableExtensions;
    }

    public INavigatorContentDescriptor getContentDescriptorById(String anExtensionId) {
        return CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(anExtensionId);
    }

    public INavigatorContentExtension getContentExtensionById(String anExtensionId) {
        NavigatorContentDescriptor descriptor = CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(anExtensionId);
        if (descriptor != null) {
            return this.getExtension(descriptor);
        }
        return null;
    }

    public Set findContentExtensionsByTriggerPoint(Object anElement) {
        return this.findContentExtensionsByTriggerPoint(anElement, true);
    }

    public Set findContentExtensionsByTriggerPoint(Object anElement, boolean toLoadIfNecessary) {
        Set enabledDescriptors = this.findDescriptorsByTriggerPoint(anElement);
        return this.extractDescriptorInstances(enabledDescriptors, toLoadIfNecessary);
    }

    public Set findContentExtensionsWithPossibleChild(Object anElement) {
        return this.findContentExtensionsWithPossibleChild(anElement, true);
    }

    public Set findContentExtensionsWithPossibleChild(Object anElement, boolean toLoadIfNecessary) {
        Set enabledDescriptors = this.findDescriptorsWithPossibleChild(anElement);
        return this.extractDescriptorInstances(enabledDescriptors, toLoadIfNecessary);
    }

    public synchronized void rememberContribution(NavigatorContentDescriptor source, Object[] elements) {
        if (source != null && elements != null) {
            int i = 0;
            while (i < elements.length) {
                this.rememberContribution(source, elements[i]);
                ++i;
            }
        }
    }

    public synchronized void rememberContribution(NavigatorContentDescriptor source, Object element) {
        Map memory = this.getContributionMemory();
        if (element != null) {
            if (memory.containsKey(element)) {
                return;
            }
            if (source != null) {
                memory.put(element, source);
            }
        }
    }

    public synchronized void forgetContribution(Object element) {
        if (element != null) {
            this.getContributionMemory().remove(element);
        }
    }

    public NavigatorContentDescriptor getSourceOfContribution(Object element) {
        return (NavigatorContentDescriptor)this.getContributionMemory().get(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getContributionMemory() {
        if (this.contributionMemory != null) {
            return this.contributionMemory;
        }
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            if (this.contributionMemory == null) {
                this.contributionMemory = new WeakHashMap();
            }
        }
        return this.contributionMemory;
    }

    public Set findDescriptorsByTriggerPoint(Object anElement) {
        NavigatorContentDescriptor descriptor = this.getSourceOfContribution(anElement);
        TreeSet<NavigatorContentDescriptor> result = new TreeSet<NavigatorContentDescriptor>(ExtensionPriorityComparator.INSTANCE);
        if (descriptor != null) {
            result.add(descriptor);
        }
        result.addAll(CONTENT_DESCRIPTOR_REGISTRY.findDescriptorsForTriggerPoint(anElement, this.assistant));
        return result;
    }

    public Set findDescriptorsWithPossibleChild(Object anElement) {
        return this.findDescriptorsWithPossibleChild(anElement, true);
    }

    public Set findDescriptorsWithPossibleChild(Object anElement, boolean toComputeOverrides) {
        NavigatorContentDescriptor descriptor = this.getSourceOfContribution(anElement);
        TreeSet<NavigatorContentDescriptor> result = new TreeSet<NavigatorContentDescriptor>(ExtensionPriorityComparator.INSTANCE);
        if (descriptor != null) {
            result.add(descriptor);
        }
        result.addAll(CONTENT_DESCRIPTOR_REGISTRY.findDescriptorsForPossibleChild(anElement, this.assistant, toComputeOverrides));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExtensionActivation(String aViewerId, String[] aNavigatorExtensionId, boolean toEnable) {
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            try {
                Iterator iter = this.contentExtensions.keySet().iterator();
                while (iter.hasNext()) {
                    NavigatorContentDescriptor key = (NavigatorContentDescriptor)iter.next();
                    INavigatorActivationService activation = this.getActivationService();
                    if (activation.isNavigatorExtensionActive(key.getId())) continue;
                    NavigatorContentExtension extension = (NavigatorContentExtension)this.contentExtensions.get(key);
                    iter.remove();
                    if (extension == null) continue;
                    extension.dispose();
                }
            }
            catch (RuntimeException e) {
                String msg = e.getMessage() != null ? e.getMessage() : e.toString();
                NavigatorPlugin.logError(0, msg, e);
            }
        }
        this.update();
    }

    public void update() {
        this.rootContentProviders = null;
        if (this.structuredViewerManager != null) {
            this.structuredViewerManager.safeRefresh();
        }
    }

    public final String getViewerId() {
        return this.viewerDescriptor.getViewerId();
    }

    public final NavigatorContentExtension getExtension(INavigatorContentDescriptor aDescriptorKey) {
        return this.getExtension(aDescriptorKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NavigatorContentExtension getExtension(INavigatorContentDescriptor aDescriptorKey, boolean toLoadIfNecessary) {
        NavigatorContentExtension extension = (NavigatorContentExtension)this.contentExtensions.get(aDescriptorKey);
        if (extension != null || !toLoadIfNecessary) {
            return extension;
        }
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            extension = (NavigatorContentExtension)this.contentExtensions.get(aDescriptorKey);
            if (extension == null) {
                extension = new NavigatorContentExtension((NavigatorContentDescriptor)aDescriptorKey, this, this.structuredViewerManager);
                this.contentExtensions.put(aDescriptorKey, extension);
                this.notifyListeners(extension);
            }
        }
        return extension;
    }

    public INavigatorViewerDescriptor getViewerDescriptor() {
        return this.viewerDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreState(final IMemento aMemento) {
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            ArrayList<1> runnables = new ArrayList<1>();
            Iterator extensionItr = this.getExtensions().iterator();
            while (extensionItr.hasNext()) {
                final NavigatorContentExtension element = (NavigatorContentExtension)extensionItr.next();
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void run() throws Exception {
                        element.restoreState(aMemento);
                    }

                    public void handleException(Throwable exception) {
                        NavigatorPlugin.logError(0, "Could not restore state for Common Navigator content extension" + element.getId(), exception);
                    }
                };
                runnables.add(runnable);
            }
            Iterator iterator = runnables.iterator();
            while (iterator.hasNext()) {
                ISafeRunnable runnable = (ISafeRunnable)iterator.next();
                SafeRunner.run((ISafeRunnable)runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(IMemento aMemento) {
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            Iterator extensionItr = this.getExtensions().iterator();
            while (extensionItr.hasNext()) {
                NavigatorContentExtension element = (NavigatorContentExtension)extensionItr.next();
                element.saveState(aMemento);
            }
        }
    }

    public boolean isActive(String anExtensionId) {
        return this.assistant.isActive(anExtensionId);
    }

    public boolean isVisible(String anExtensionId) {
        return this.assistant.isVisible(anExtensionId);
    }

    protected final Collection getExtensions() {
        return this.contentExtensions.size() > 0 ? Collections.unmodifiableCollection(this.contentExtensions.values()) : Collections.EMPTY_LIST;
    }

    public void addListener(INavigatorContentServiceListener aListener) {
        this.listeners.add(aListener);
    }

    public INavigatorFilterService getFilterService() {
        if (this.navigatorFilterService == null) {
            this.navigatorFilterService = new NavigatorFilterService(this);
        }
        return this.navigatorFilterService;
    }

    public INavigatorSorterService getSorterService() {
        if (this.navigatorSorterService == null) {
            this.navigatorSorterService = new NavigatorSorterService(this);
        }
        return this.navigatorSorterService;
    }

    public INavigatorPipelineService getPipelineService() {
        if (this.navigatorPipelineService == null) {
            this.navigatorPipelineService = new NavigatorPipelineService(this);
        }
        return this.navigatorPipelineService;
    }

    public INavigatorDnDService getDnDService() {
        if (this.navigatorDnDService == null) {
            this.navigatorDnDService = new NavigatorDnDService(this);
        }
        return this.navigatorDnDService;
    }

    public INavigatorActivationService getActivationService() {
        if (this.navigatorActivationService == null) {
            this.navigatorActivationService = new NavigatorActivationService(this);
        }
        return this.navigatorActivationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INavigatorSaveablesService getSaveablesService() {
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            if (this.navigatorSaveablesService == null) {
                this.navigatorSaveablesService = new NavigatorSaveablesService(this);
                this.assistant.addListener(this.navigatorSaveablesService);
            }
            return this.navigatorSaveablesService;
        }
    }

    public NavigatorExtensionStateService getExtensionStateService() {
        if (this.navigatorExtensionStateService == null) {
            this.navigatorExtensionStateService = new NavigatorExtensionStateService(this);
        }
        return this.navigatorExtensionStateService;
    }

    public Shell getShell() {
        if (this.structuredViewerManager != null && this.structuredViewerManager.getViewer() != null) {
            return this.structuredViewerManager.getViewer().getControl().getShell();
        }
        return null;
    }

    protected boolean isRootExtension(String anExtensionId) {
        return this.assistant.isRootExtension(anExtensionId);
    }

    public void removeListener(INavigatorContentServiceListener aListener) {
        this.listeners.remove(aListener);
    }

    public String toString() {
        return "ContentService[" + this.viewerDescriptor.getViewerId() + "]";
    }

    private void notifyListeners(NavigatorContentExtension aDescriptorInstance) {
        if (this.listeners.size() == 0) {
            return;
        }
        INavigatorContentServiceListener listener = null;
        ArrayList<INavigatorContentServiceListener> failedListeners = null;
        Iterator listenersItr = this.listeners.iterator();
        while (listenersItr.hasNext()) {
            try {
                listener = (INavigatorContentServiceListener)listenersItr.next();
                listener.onLoad(aDescriptorInstance);
            }
            catch (RuntimeException runtimeException) {
                if (failedListeners == null) {
                    failedListeners = new ArrayList<INavigatorContentServiceListener>();
                }
                failedListeners.add(listener);
            }
        }
        if (failedListeners != null) {
            this.listeners.removeAll(failedListeners);
        }
    }

    private ITreeContentProvider[] extractContentProviders(Set theDescriptorInstances) {
        if (theDescriptorInstances.size() == 0) {
            return NO_CONTENT_PROVIDERS;
        }
        ArrayList<ITreeContentProvider> resultProvidersList = new ArrayList<ITreeContentProvider>();
        Iterator itr = theDescriptorInstances.iterator();
        while (itr.hasNext()) {
            resultProvidersList.add(((NavigatorContentExtension)itr.next()).internalGetContentProvider());
        }
        return resultProvidersList.toArray(new ITreeContentProvider[resultProvidersList.size()]);
    }

    private Set extractDescriptorInstances(Set theDescriptors, boolean toLoadAllIfNecessary) {
        if (theDescriptors.size() == 0) {
            return Collections.EMPTY_SET;
        }
        TreeSet<NavigatorContentExtension> resultInstances = new TreeSet<NavigatorContentExtension>(ExtensionPriorityComparator.INSTANCE);
        Iterator descriptorIter = theDescriptors.iterator();
        while (descriptorIter.hasNext()) {
            NavigatorContentExtension extension = this.getExtension((NavigatorContentDescriptor)descriptorIter.next(), toLoadAllIfNecessary);
            if (extension == null) continue;
            resultInstances.add(extension);
        }
        return resultInstances;
    }

    private ILabelProvider[] extractLabelProviders(Set theDescriptorInstances) {
        if (theDescriptorInstances.size() == 0) {
            return NO_LABEL_PROVIDERS;
        }
        ArrayList<ICommonLabelProvider> resultProvidersList = new ArrayList<ICommonLabelProvider>();
        Iterator itr = theDescriptorInstances.iterator();
        while (itr.hasNext()) {
            resultProvidersList.add(((NavigatorContentExtension)itr.next()).getLabelProvider());
        }
        return resultProvidersList.toArray(new ILabelProvider[resultProvidersList.size()]);
    }
}

