/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.pos;

import edu.mit.parsing.core.ParsingMessages;
import edu.mit.parsing.core.ParsingPlugin;
import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.colloc.IColloc;
import edu.mit.parsing.core.rep.pos.IPOSTagger;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.IndexedTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.pos.PennTag;
import edu.mit.parsing.core.rep.pos.PosTag;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.AbstractDescFactory2;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.DistinctRegionSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.IntervalSet;
import edu.mit.story.core.property.ConfigDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.ManagerBackedListValidator;
import edu.mit.story.core.validation.PreferenceStoreBackedPropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSDefaultFactory
extends AbstractDescFactory2<IndexedTag> {
    private IPOSTagger tagger;
    private static final String[] allowedAuxForms = new String[]{"be", "been", "am", "is", "'re", "are", "was", "were", "'ll", "will", "have", "has", "had", "'ve"};

    public POSDefaultFactory() {
        super(POSRep.getInstance(), Arrays.asList(TokenRep.getInstance(), SentenceRep.getInstance()));
    }

    protected boolean doInit(IStoryModel model) {
        String taggerID = (String)this.getConfiguration().get((Object)"tagger");
        if (taggerID == null) {
            return false;
        }
        this.tagger = (IPOSTagger)ParsingPlugin.getDefault().getTaggerManager().create(taggerID);
        if (this.tagger == null) {
            return false;
        }
        this.tagger.init();
        return true;
    }

    protected DistinctRegionSet calculateRegions(StoryChangeEvent event) {
        Change tokenChange = event.getChange(TokenRep.getInstance());
        Change sentChange = event.getChange(SentenceRep.getInstance());
        IHasPositionSet tokenRegions = tokenChange == null ? null : tokenChange.getChanges((IFlag)Flag.DESCS);
        IHasPositionSet sentRegions = sentChange == null ? null : sentChange.getChanges((IFlag)Flag.DESCS);
        IntervalSet result = new IntervalSet();
        IDescSet sentDescs = event.provider.getData().getDescriptions(SentenceRep.getInstance());
        IDescSet posDescs = event.provider.getData().getDescriptions(POSRep.getInstance());
        if (tokenRegions != null) {
            for (IHasPosition region : tokenRegions) {
                result.addAll((Collection)sentDescs.openSet(region));
                result.addAll((Collection)posDescs.openSet(region));
            }
        }
        if (sentRegions != null) {
            for (IHasPosition region : sentRegions) {
                result.addAll((Collection)sentDescs.openSet(region));
                result.addAll((Collection)posDescs.openSet(region));
            }
        }
        return result;
    }

    protected IHasPositionSet<IndexedTag> calculateData(IHasPosition region, IStoryModel provider) {
        IDescSet sentDescs = provider.getData().getDescriptions(SentenceRep.getInstance()).openSet(region);
        if (sentDescs.size() == 0) {
            return null;
        }
        HasPositionSet result = null;
        for (IDesc sentDesc : sentDescs) {
            IHasPositionSet<IndexedTag> tags = this.tagSentence((IHasPosition)sentDesc, provider);
            if (tags == null) continue;
            if (result == null) {
                result = new HasPositionSet();
            }
            result.addAll(tags);
        }
        return result;
    }

    protected IHasPositionSet<IndexedTag> tagSentence(IHasPosition sentence, IStoryModel model) {
        IDescSet tokenDescSet = model.getData().getDescriptions(TokenRep.getInstance()).openSet(sentence);
        int size = tokenDescSet.size();
        if (size == 0) {
            return null;
        }
        ArrayList<IDesc> tokenDescs = new ArrayList<IDesc>(size);
        ArrayList<String> tokens = new ArrayList<String>(size);
        for (IDesc desc : tokenDescSet) {
            tokenDescs.add(desc);
            IToken token = (IToken)desc.getData();
            tokens.add(token.getToken());
        }
        List<String> tags = this.tagger.tag(tokens);
        HasPositionSet result = new HasPositionSet();
        HashMap<IDesc, PennTag> tagMap = new HashMap<IDesc, PennTag>();
        int i = 0;
        while (i < tags.size()) {
            PennTag tag = PennTag.getTag(tags.get(i));
            if (tag != null) {
                boolean isAux = false;
                if (POSDefaultFactory.couldBeAuxiliary(tag, (String)tokens.get(i)) && i + 1 < tags.size()) {
                    PennTag nextTag = PennTag.getTag(tags.get(i + 1));
                    isAux = nextTag != null && nextTag.isVerb();
                }
                result.add((Object)new IndexedTag((IHasPosition)tokenDescs.get(i), new PosTag((IDesc)tokenDescs.get(i), tag, isAux)));
                tagMap.put((IDesc)tokenDescs.get(i), tag);
            }
            ++i;
        }
        if (!model.supports(CollocRep.getInstance())) {
            return result;
        }
        IDescSet collocDescs = model.getData().getDescriptions(CollocRep.getInstance()).openSet(sentence);
        for (IDesc collocDesc : collocDescs) {
            ITag collocTag = null;
            IColloc colloc = (IColloc)collocDesc.getData();
            for (IDesc tokenDesc : colloc.getTokens()) {
                ITag partTag = (ITag)tagMap.get(tokenDesc);
                if (collocTag != null && !partTag.isOpenClass()) continue;
                collocTag = partTag;
            }
            result.add((Object)new IndexedTag((IHasPosition)collocDesc, new PosTag(collocDesc, collocTag, false)));
        }
        return result;
    }

    public static boolean couldBeAuxiliary(ITag tag, String word) {
        if (tag.isVerb()) {
            String[] stringArray = allowedAuxForms;
            int n = allowedAuxForms.length;
            int n2 = 0;
            while (n2 < n) {
                String allowedForm = stringArray[n2];
                if (word.equalsIgnoreCase(allowedForm)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected IConfigDescriptor createConfigurationDescriptor() {
        return new FactoryConfigDescriptor();
    }

    public static class FactoryConfigDescriptor
    extends ConfigDescriptor {
        private static final long serialVersionUID = 1L;

        public FactoryConfigDescriptor() {
            PreferenceStoreBackedPropertyDescriptor d = new PreferenceStoreBackedPropertyDescriptor("tagger", ParsingMessages.FACTORY_PARAM_NAME_Tagger, ParsingMessages.FACTORY_PARAM_DESC_Tagger, (IValidator)new ManagerBackedListValidator(ParsingPlugin.getDefault().getTaggerManager()), true, "DefaultTaggerID", ParsingPlugin.getDefault().getPreferenceStore());
            this.put(d.getID(), d);
        }
    }
}

