/* Filename: ReferentPropertyModel.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Sep 24, 2009
 */
package edu.mit.discourse.core.rep.refprops.model;

import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.discourse.core.rep.refprops.IReferentProperty;
import edu.mit.discourse.core.rep.refprops.PropertyType;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.discourse.core.rep.refprops.ReferentProperty;
import edu.mit.parsing.core.model.SegmentSetModel;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.ui 1.0.0
 */
public class ReferentPropertyModel extends SegmentSetModel implements IReferentPropertyModel {
	
	private IDesc loaded = null;
	private IDesc refexp = null;
	private PropertyType type = getDefaultType();

	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @param storyModel
	 * @since edu.mit.discourse.ui 1.0.0
	 */
	public ReferentPropertyModel(IStoryModel storyModel) {
		super(TokenRep.getInstance(), storyModel);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.refprops.IReferentProperty#getType()
	 */
	public PropertyType getType() {
		return type;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.refprops.model.IReferentPropertyModel#setType(edu.mit.discourse.core.rep.refprops.PropertyType)
	 */
	public void setType(PropertyType type) {
		if(type == null)
			type = getDefaultType();
		if(this.type == type)
			return;
		this.type = type;
		fireChanged();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.refprops.IReferentProperty#getReferringExpression()
	 */
	public IDesc getReferringExpression() {
		return refexp;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.refprops.model.IReferentPropertyModel#setReferringExpression(edu.mit.story.core.desc.IDesc)
	 */
	public void setReferringExpression(IDesc refexp) {
		if(!RefExpRep.getInstance().isType(refexp))
			throw new IllegalArgumentException();
		this.refexp = refexp;
		fireChanged();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.parsing.core.model.SegmentSetModel#getSegments()
	 */
	public ISegmentSet getExtent() {
		return new SegmentSet(super.getSegments());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.refprops.model.IReferentPropertyModel#getLoaded()
	 */
	public IDesc getLoaded() {
		return loaded;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.ui.models.IReferentPropertyModel#load(edu.mit.story.core.desc.IDesc)
	 */
	
	public void load(IDesc desc) {
		if(!RefPropRep.getInstance().isType(desc))
			throw new IllegalArgumentException();
		internalClear();
		this.loaded = desc;
		IReferentProperty prop = (IReferentProperty)desc.getData();
		this.type = prop.getType();
		setReferringExpression(prop.getReferringExpression());
		setSegments(prop.getExtent());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.parsing.core.model.SegmentSetModel#isCleared()
	 */
	@Override
	public boolean isCleared() {
		if(type != getDefaultType())
			return false;
		return super.isCleared();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.parsing.ui.models.SegmentSetModel#internalClear()
	 */
	protected void internalClear(){
		loaded = null;
		type = getDefaultType();
		super.internalClear();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.refprops.IReferentProperty#getReferent()
	 */
	
	/**
	 * TODO: Write comment
	 *
	 * @return
	 * @since edu.mit.discourse.core 1.0.0
	 */
	protected PropertyType getDefaultType() {
		return PropertyType.UNKNOWN;
	}

	public IHasPosition calculatePosition() {
		return new SimplePosition(getSegments());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.discourse.core.rep.refprops.model.IReferentPropertyModel#create()
	 */
	public IReferentProperty create() {
		return new ReferentProperty(type, getReferringExpression(), getSegments());
	}

	public IHasPosition getDisplayPosition() {
		throw new UnsupportedOperationException();
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IData#equals(edu.mit.story.core.desc.IData, edu.mit.story.core.align.IAlignedStoryModel)
	 */
	public boolean equals(IData tgtData, IAlignedStoryModel model) {
		throw new UnsupportedOperationException();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#recalculate(edu.mit.story.core.model.IStoryModel)
	 */
	
	public IStructuredData recalculate(IDesc container, IStoryModel model) {
		throw new UnsupportedOperationException();
	}

}
