/* Filename: AllVerbsTaggedRule.java
 * Author: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Nov 4, 2009
 */
package edu.mit.discourse.core.rep.coref.rules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.discourse.core.rep.coref.ICoref;
import edu.mit.discourse.core.rep.coref.problems.MultiplyUsedRefexpProblem;
import edu.mit.discourse.core.rep.coref.problems.UnusedRefexpProblem;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.semantics.core 1.0.0
 */
public class RefExpUseRule extends AbstractBuildRule {

	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @since edu.mit.semantics.core 1.0.0
	 */
	public RefExpUseRule() {
		super(CorefRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.build.IBuildRule#build(edu.mit.story.core.model.IStoryModel)
	 */
	public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
		
		Map<IDesc, Set<IDesc>> refexpMap = new HashMap<IDesc, Set<IDesc>>();
		
		// map all referring expressions to their uses
		ICoref coref;
		Set<IDesc> corefs;
		for(IDesc corefDesc : model.getData().getDescriptions(CorefRep.getInstance())){
			coref = (ICoref)corefDesc.getData();
			for(IDesc refexp : coref.getReferentialExpressions()){
				corefs = refexpMap.get(refexp);
				if(corefs == null){
					corefs = new HashSet<IDesc>(1);
					refexpMap.put(refexp, corefs);
				}
				corefs.add(corefDesc);;
			}
		}
		
		IHasPositionSet<IStoryProblem> result = new HasPositionSet<IStoryProblem>();
		// multiples
		for(Entry<IDesc, Set<IDesc>> entry : refexpMap.entrySet())
			if(entry.getValue().size() > 1)
				result.add(new MultiplyUsedRefexpProblem(entry.getKey(), entry.getValue(), getID()));
		// unused
		for(IDesc refexp : model.getData().getDescriptions(RefExpRep.getInstance()))
			if(!refexpMap.containsKey(refexp))
				result.add(new UnusedRefexpProblem(refexp, getID()));
		return result;
	}

}
