/* Filename: AmbiguousSenseProblem.java
 * Author: M. A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Nov 1, 2009
 */
package edu.mit.discourse.core.rep.coref.problems;

import java.util.Collection;
import java.util.Collections;

import org.eclipse.core.resources.IMarker;

import edu.mit.discourse.core.rep.refexp.IRefExp;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since StoryWorkbench 1.0
 */
public class MultiplyUsedRefexpProblem extends StoryProblem {
	
	public static final String ID = "edu.mit.parsing.core.problem.multiplyUsedRefexp";

	/**
	 * TODO: Write comment
	 *
	 * @since StoryWorkbench 1.0
	 */
	public MultiplyUsedRefexpProblem(IDesc refexp, Collection<IDesc> corefs, String buildRuleID) {
		super(POSRep.getInstance(), buildRuleID);
		setID(ID);
		setName("Multiple Use of a Referring Expression");
		setDescs(Collections.singleton(refexp));
		setSeverity(IMarker.SEVERITY_ERROR);
		
		if(corefs.size() < 2)
			throw new IllegalArgumentException();
		
		// collect refexps
		IDescSet refexps = getDescs().getDescriptions(RefExpRep.getInstance());
		if(refexps.isEmpty())
			throw new IllegalArgumentException();

		IDesc d = refexps.first();
		setPosition(d);
		
		IRefExp re = (IRefExp)d.getData();
		StringBuilder sb = new StringBuilder();
		sb.append("The referring expression '");
		sb.append(re.getDisplayText());
		sb.append("' is used in ");
		sb.append(Integer.toString(corefs.size()));
		sb.append(" coreference clusters; it should only be used in one");
		
		setDescription(sb.toString());
	}

}
