/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.build;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.build.IBaseBuildRule;
import edu.mit.story.core.descriptor.Registered;
import edu.mit.story.core.rep.IRep;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractBaseBuildRule
extends Registered
implements IBaseBuildRule {
    private final IRep rep;
    private String checkedMsg;
    private boolean isCompressing;

    public AbstractBaseBuildRule(IRep rep) {
        if (rep == null) {
            throw new NullPointerException();
        }
        this.rep = rep;
    }

    public IRep getRep() {
        return this.rep;
    }

    public String getCheckedMessage() {
        if (this.checkedMsg == null) {
            throw new IllegalStateException();
        }
        return this.checkedMsg;
    }

    public void setCheckedMessage(String msg) {
        if (this.checkedMsg != null) {
            throw new IllegalStateException();
        }
        if (msg.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.checkedMsg = msg;
    }

    public static void markChecked(IResource resource, IBaseBuildRule rule) {
        try {
            IMarker marker = resource.createMarker("edu.mit.story.core.marker.checked");
            marker.setAttribute("generatedBy", (Object)rule.getID());
            marker.setAttribute("severity", 0);
            marker.setAttribute("message", (Object)rule.getCheckedMessage());
            marker.setAttribute("location", (Object)"story");
            marker.setAttribute("repID", (Object)rule.getRep().getID());
        }
        catch (CoreException e) {
            Status status = new Status(4, "edu.mit.story.core", "", (Throwable)e);
            StoryPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    public boolean isCompressing() {
        return this.isCompressing;
    }

    public void setCompressing(boolean value) {
        this.isCompressing = value;
    }
}

