/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.verbnet;

import edu.mit.jverbnet.data.IVersion;
import edu.mit.jverbnet.data.Version;
import edu.mit.semantics.core.verbnet.IVerbnetDescriptor;
import edu.mit.semantics.core.verbnet.IWorkbenchVerbIndex;
import edu.mit.semantics.core.verbnet.WorkbenchVerbIndex;
import edu.mit.story.core.descriptor.CreatableDescriptor;
import edu.mit.story.core.util.LogUtils;
import edu.mit.wordnet.core.WordnetPlugin;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerbnetDescriptor
extends CreatableDescriptor<IWorkbenchVerbIndex>
implements IVerbnetDescriptor {
    private final IVersion version;
    private final String location;
    private IWorkbenchVerbIndex index;

    public VerbnetDescriptor(IConfigurationElement element, String version, String location) {
        super(element);
        if (location.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.location = location;
        this.version = Version.parseVersion((CharSequence)version);
    }

    @Override
    public IVersion getVersion() {
        return this.version;
    }

    public IWorkbenchVerbIndex create() {
        if (this.index == null) {
            IConfigurationElement element = this.getConfigurationElement();
            String bundleName = element.getContributor().getName();
            Bundle bundle = Platform.getBundle((String)bundleName);
            URL url = bundle.getEntry(this.location);
            try {
                this.index = new WorkbenchVerbIndex(url, this.getID(), this.version);
                this.index.open();
            }
            catch (IOException e) {
                LogUtils.logError((Plugin)WordnetPlugin.getDefault(), (Throwable)e);
            }
        }
        return this.index;
    }
}

