/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.mentalstate.rules;

import com.google.common.collect.HashMultimap;
import edu.mit.semantics.core.rep.mentalstate.IMentalState;
import edu.mit.semantics.core.rep.mentalstate.MentalStateRep;
import edu.mit.semantics.core.rep.mentalstate.problems.MultipleMentalStateProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.util.EntryImpl;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleMentalStatePerPair
extends AbstractBuildRule {
    public static final String ID = SingleMentalStatePerPair.class.getCanonicalName();

    public SingleMentalStatePerPair() {
        super(MentalStateRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        if (!model.supports(MentalStateRep.getInstance())) {
            return null;
        }
        HashMultimap eventCharStateTable = HashMultimap.create();
        for (IDesc stateD : model.getData().getDescriptions(MentalStateRep.getInstance())) {
            IMentalState state = (IMentalState)stateD.getData();
            EntryImpl e = new EntryImpl((Object)state.getEvent(), (Object)state.getCharacter());
            eventCharStateTable.put((Object)e, (Object)stateD);
        }
        HasPositionSet result = new HasPositionSet();
        for (Map.Entry dups : eventCharStateTable.asMap().entrySet()) {
            if (((Collection)dups.getValue()).size() <= 1) continue;
            result.add((Object)new MultipleMentalStateProblem((IDesc)((Map.Entry)dups.getKey()).getKey(), (IDesc)((Map.Entry)dups.getKey()).getValue(), ((Collection)dups.getValue()).size(), this.getID()));
        }
        return result;
    }
}

