/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.UAContentFilter;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpEvaluationContext;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.webapp.data.ActivitiesData;
import org.eclipse.help.internal.webapp.data.EnabledTopicUtils;
import org.eclipse.help.internal.webapp.data.TopicFinder;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class TocData
extends ActivitiesData {
    private String tocParameter;
    private String topicHref;
    private String expandPathParam;
    private String topicHelpHref;
    private int selectedToc;
    private int[] rootPath = null;
    private ITopic[] topicPath = null;
    private String numericPath;
    private IToc[] tocs;
    private String imagesDirectory;

    public TocData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        String pathStr;
        this.tocParameter = request.getParameter("toc");
        this.topicHref = request.getParameter("topic");
        this.expandPathParam = request.getParameter("expandPath");
        if (this.tocParameter != null && this.tocParameter.length() == 0) {
            this.tocParameter = null;
        }
        if (this.topicHref != null && this.topicHref.length() == 0) {
            this.topicHref = null;
        }
        if (this.expandPathParam != null && this.expandPathParam.length() == 0) {
            this.expandPathParam = null;
        }
        String anchor = request.getParameter("anchor");
        if (this.topicHref != null && anchor != null) {
            this.topicHref = String.valueOf(this.topicHref) + '#' + anchor;
        }
        if ((pathStr = request.getParameter("path")) != null && pathStr.length() > 0) {
            String[] paths = pathStr.split("_", -1);
            int[] indexes = new int[paths.length];
            boolean indexesOK = true;
            int i = 0;
            while (i < paths.length) {
                try {
                    indexes[i] = Integer.parseInt(paths[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    indexesOK = false;
                    break;
                }
                if (indexesOK) {
                    this.rootPath = indexes;
                }
                ++i;
            }
        }
        this.imagesDirectory = this.preferences.getImagesDirectory();
        this.loadTocs();
    }

    public boolean isRemoteHelpError() {
        boolean isError;
        boolean bl = isError = RemoteHelp.getError() != null;
        if (isError) {
            RemoteHelp.clearError();
        }
        return isError;
    }

    public int getTocCount() {
        return this.tocs.length;
    }

    public String getTocLabel(int i) {
        return this.tocs[i].getLabel();
    }

    public String getTocHref(int i) {
        return this.tocs[i].getHref();
    }

    public String getTocDescriptionTopic(int i) {
        return UrlUtil.getHelpURL(this.tocs[i].getTopic(null).getHref());
    }

    public int getSelectedToc() {
        return this.selectedToc;
    }

    public String getSelectedTopic() {
        if (this.topicHref != null && this.topicHref.length() > 0) {
            return UrlUtil.getHelpURL(this.topicHref);
        }
        if (this.selectedToc == -1) {
            return null;
        }
        IToc toc = this.tocs[this.selectedToc];
        ITopic tocDescription = toc.getTopic(null);
        if (tocDescription != null) {
            return UrlUtil.getHelpURL(tocDescription.getHref());
        }
        return UrlUtil.getHelpURL(null);
    }

    public IToc[] getTocs() {
        return this.tocs;
    }

    public boolean isEnabled(int toc) {
        return EnabledTopicUtils.isEnabled(this.tocs[toc]);
    }

    private boolean isEnabled(IToc toc) {
        if (!this.isAdvancedUI()) {
            return true;
        }
        return HelpBasePlugin.getActivitySupport().isEnabled(toc.getHref()) && !UAContentFilter.isFiltered((Object)toc, (IEvaluationContext)HelpEvaluationContext.getContext());
    }

    private void loadTocs() {
        this.tocs = HelpPlugin.getTocManager().getTocs(this.getLocale());
        this.selectedToc = -1;
        if (this.isExpandPath()) {
            this.getEnabledTopicPath();
        } else if (this.tocParameter != null && this.tocParameter.length() > 0) {
            int i = 0;
            while (this.selectedToc == -1 && i < this.tocs.length) {
                if (this.tocParameter.equals(this.tocs[i].getHref())) {
                    this.selectedToc = i;
                }
                ++i;
            }
        } else {
            TopicFinder finder = new TopicFinder(this.topicHref, this.tocs);
            this.topicPath = finder.getTopicPath();
            this.selectedToc = finder.getSelectedToc();
            this.numericPath = finder.getNumericPath();
        }
    }

    private void getEnabledTopicPath() {
        int[] path = UrlUtil.splitPath(this.expandPathParam);
        if (path != null) {
            int enabled = path[0] + 1;
            int i = 0;
            while (enabled > 0 && i < this.tocs.length) {
                if (EnabledTopicUtils.isEnabled(this.tocs[i]) && --enabled == 0) {
                    this.selectedToc = i;
                }
                ++i;
            }
            if (this.selectedToc != -1) {
                this.topicPath = TocData.decodePath(path, this.tocs[this.selectedToc]);
            }
        } else {
            this.selectedToc = -1;
        }
    }

    public static ITopic[] decodePath(int[] path, IToc toc) {
        ITopic[] topicPath = new ITopic[path.length - 1];
        try {
            if (path.length > 1) {
                ITopic[] topics = toc.getTopics();
                ITopic[] enabledTopics = EnabledTopicUtils.getEnabled(topics);
                topicPath[0] = enabledTopics[path[1]];
            }
            int i = 1;
            while (i < topicPath.length) {
                ITopic[] topics = topicPath[i - 1].getSubtopics();
                ITopic[] enabledTopics = EnabledTopicUtils.getEnabled(topics);
                topicPath[i] = enabledTopics[path[i + 1]];
                ++i;
            }
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
        return topicPath;
    }

    public void generateBasicToc(int toc, Writer out) throws IOException {
        ITopic[] topics = this.getEnabledSubtopics(this.tocs[toc]);
        int i = 0;
        while (i < topics.length) {
            this.generateBasicTopic(topics[i], out);
            ++i;
        }
    }

    private void generateBasicTopic(ITopic topic, Writer out) throws IOException {
        boolean hasNodes;
        out.write("<li>");
        ITopic[] topics = this.getEnabledSubtopics(topic);
        boolean bl = hasNodes = topics.length > 0;
        if (hasNodes) {
            out.write("<nobr>");
            out.write("<a ");
            if (this.getSelectedTopicHelpHref().equals(topic.getHref())) {
                out.write("name=\"selectedItem\" ");
            }
            out.write("href=\"" + UrlUtil.getHelpURL(topic.getHref()) + "\"" + ">");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/container_obj.gif' alt=\"\" border=0>&nbsp;");
            out.write(UrlUtil.htmlEncode(topic.getLabel()));
            out.write("</a>");
            out.write("</nobr>");
            out.write("<ul>\n");
            int i = 0;
            while (i < topics.length) {
                this.generateBasicTopic(topics[i], out);
                ++i;
            }
            out.write("</ul>\n");
        } else {
            out.write("<nobr>");
            out.write("<a ");
            if (this.getSelectedTopicHelpHref().equals(topic.getHref())) {
                out.write("name=\"selectedItem\" ");
            }
            out.write("href=\"" + UrlUtil.getHelpURL(topic.getHref()) + "\"" + ">");
            out.write("<img src='");
            out.write(this.imagesDirectory);
            out.write("/topic.gif' alt=\"\" border=0>&nbsp;");
            out.write(UrlUtil.htmlEncode(topic.getLabel()));
            out.write("</a>");
            out.write("</nobr>");
        }
        out.write("</li>\n");
    }

    private String getSelectedTopicHelpHref() {
        if (this.topicHelpHref == null) {
            String topic = this.getSelectedTopic();
            if (topic == null || topic.length() == 0) {
                this.topicHelpHref = "";
                return this.topicHelpHref;
            }
            int index = topic.indexOf("/topic/");
            if (index != -1) {
                topic = topic.substring(index + 6);
            }
            if ((index = topic.indexOf(63)) != -1) {
                topic = topic.substring(0, index);
            }
            this.topicHelpHref = topic;
            if (topic == null) {
                this.topicHelpHref = "";
            }
        }
        return this.topicHelpHref;
    }

    public ITopic[] getEnabledSubtopics(Object element) {
        List topics = this.getEnabledSubtopicList(element);
        return topics.toArray(new ITopic[topics.size()]);
    }

    private List getEnabledSubtopicList(Object element) {
        List<ITopic> children;
        if (element instanceof IToc && !this.isEnabled((IToc)element)) {
            return Collections.EMPTY_LIST;
        }
        if (element instanceof IToc) {
            children = Arrays.asList(((IToc)element).getTopics());
        } else if (element instanceof ITopic) {
            children = Arrays.asList(((ITopic)element).getSubtopics());
        } else {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ITopic> childTopics = new ArrayList<ITopic>(children.size());
        Iterator<ITopic> childrenIt = children.iterator();
        while (childrenIt.hasNext()) {
            ITopic c = childrenIt.next();
            if (c instanceof ITopic) {
                if ((c.getHref() == null || c.getHref().length() <= 0) && this.getEnabledSubtopicList(c).size() <= 0 || UAContentFilter.isFiltered((Object)c, (IEvaluationContext)HelpEvaluationContext.getContext())) continue;
                childTopics.add(c);
                continue;
            }
            childTopics.addAll(this.getEnabledSubtopicList(c));
        }
        return childTopics;
    }

    private void generateTopicLinks(ITopic topic, Writer w, int indent) {
        String topicHref = topic.getHref();
        try {
            if (indent == 0) {
                w.write("<b>");
            }
            int tab = 0;
            while (tab < indent) {
                w.write("&nbsp;&nbsp;");
                ++tab;
            }
            if (topicHref != null && topicHref.length() > 0) {
                w.write("<a href=\"");
                if ('/' == topicHref.charAt(0)) {
                    w.write("topic");
                }
                w.write(topicHref);
                w.write("\">");
                w.write(UrlUtil.htmlEncode(topic.getLabel()));
                w.write("</a>");
            } else {
                w.write(UrlUtil.htmlEncode(topic.getLabel()));
            }
            w.write("<br>\n");
            if (indent == 0) {
                w.write("</b>");
            }
        }
        catch (IOException iOException) {}
        ITopic[] topics = topic.getSubtopics();
        int i = 0;
        while (i < topics.length) {
            this.generateTopicLinks(topics[i], w, indent + 1);
            ++i;
        }
    }

    public void generateLinks(Writer out) {
        int i = 0;
        while (i < this.tocs.length) {
            IToc toc = this.tocs[i];
            ITopic tocTopic = toc.getTopic(null);
            this.generateTopicLinks(tocTopic, out, 0);
            ITopic[] topics = toc.getTopics();
            int t = 0;
            while (t < topics.length) {
                this.generateTopicLinks(topics[t], out, 1);
                ++t;
            }
            ++i;
        }
    }

    public ITopic[] getTopicPath() {
        return this.topicPath;
    }

    public int[] getRootPath() {
        return this.rootPath;
    }

    public String getTopicHref() {
        return this.topicHref;
    }

    public String getNumericPath() {
        return this.numericPath;
    }

    public boolean isExpandPath() {
        return this.expandPathParam != null;
    }
}

