/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.content;

import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.Pointer;
import edu.mit.wordnet.ui.views.SynsetHierarchyPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IPropertyListener;

public class SynsetContentProvider
implements ITreeContentProvider {
    public static final int PROPERTY_POINTERTYPE = 1;
    IDictionary fDictionary;
    List<IPropertyListener> listeners = new ArrayList<IPropertyListener>();
    boolean fShowingSupertypes = false;
    IPointer fPointer = Pointer.HYPONYM;

    public SynsetContentProvider(IDictionary dict) {
        if (dict == null) {
            throw new NullPointerException();
        }
        this.fDictionary = dict;
    }

    public IPointer getPointerType() {
        return this.fPointer;
    }

    public void setPointerType(IPointer ptr) {
        if (ptr == this.fPointer) {
            return;
        }
        this.fPointer = ptr;
        this.firePropertyChanged(1);
    }

    public Object[] getElements(Object input) {
        if (input instanceof SynsetHierarchyPage) {
            return new Object[]{((SynsetHierarchyPage)((Object)input)).getInput()};
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ISynset) {
            ISynset synset = (ISynset)parent;
            List ids = synset.getRelatedSynsets(this.fPointer);
            ArrayList<ISynset> children = new ArrayList<ISynset>(ids.size());
            for (ISynsetID id : ids) {
                synset = this.fDictionary.getSynset(id);
                if (synset == null) continue;
                children.add(synset);
            }
            return children.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ISynset) {
            return ((ISynset)element).getRelatedSynsets(this.fPointer).size() > 0;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    protected void firePropertyChanged(int propID) {
        for (IPropertyListener listener : this.listeners) {
            listener.propertyChanged((Object)this, propID);
        }
    }

    public void addPropertyListener(IPropertyListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove(listener);
    }
}

