/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIMessages;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryMetadataGroup
extends Composite
implements Listener,
INotifyingMessageProvider {
    protected Listener listener;
    protected TableViewer table;
    protected Button moreButton;
    protected Composite parent;
    protected Composite moreParent;
    protected IMessageProvider message = Message.NO_MESSAGE;
    private final ChangeNotifier notifier = new ChangeNotifier();
    protected Text titleField;
    protected Text annotatorField;
    protected Text sourceField;

    public StoryMetadataGroup(Composite parent) {
        super(parent, 0);
        this.parent = parent;
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Group topGroup = new Group((Composite)this, 0);
        topGroup.setLayoutData((Object)new GridData(768));
        topGroup.setText(StoryUIMessages.StoryMetadataGroup_title);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        topGroup.setLayout((Layout)layout);
        Label label = new Label((Composite)topGroup, 0);
        label.setText(StoryUIMessages.StoryMetadataGroup_TitleTagEntry_label);
        this.titleField = new Text((Composite)topGroup, 2048);
        this.titleField.addListener(24, (Listener)this);
        this.titleField.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)topGroup, 0);
        label.setText(StoryUIMessages.StoryMetadataGroup_SourceTagEntry_label);
        this.sourceField = new Text((Composite)topGroup, 2048);
        this.sourceField.addListener(24, (Listener)this);
        this.sourceField.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)topGroup, 0);
        label.setText(StoryUIMessages.StoryMetadataGroup_AnnotatorTagEntry_label);
        this.annotatorField = new Text((Composite)topGroup, 2048);
        this.annotatorField.addListener(24, (Listener)this);
        this.annotatorField.setLayoutData((Object)new GridData(768));
    }

    public Map<String, String> getTags() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String value = this.getTitle();
        if (value != null & !"".equals(value)) {
            result.put("title", value);
        }
        if ((value = this.getSource()) != null & !"".equals(value)) {
            result.put("source", value);
        }
        if ((value = this.getAnnotator()) != null & !"".equals(value)) {
            result.put("annotator", value);
        }
        return result;
    }

    public void setTags(Map<String, String> tags) {
        if (tags == null) {
            this.setTitle(null);
            this.setAnnotator(null);
            this.setSource(null);
            return;
        }
        HashMap<String, String> allTags = new HashMap<String, String>();
        allTags.putAll(tags);
        String value = (String)allTags.remove("title");
        this.setTitle(value);
        value = (String)allTags.remove("annotator");
        this.setAnnotator(value);
        value = (String)allTags.remove("source");
        this.setSource(value);
    }

    public String getAnnotator() {
        return this.annotatorField.getText();
    }

    public void setAnnotator(String annotator) {
        if (annotator != null) {
            this.annotatorField.setText(annotator);
        } else {
            this.annotatorField.setText("");
        }
    }

    public String getTitle() {
        return this.titleField.getText();
    }

    public void setTitle(String title) {
        if (title != null) {
            this.titleField.setText(title);
        } else {
            this.titleField.setText("");
        }
    }

    public String getSource() {
        return this.sourceField.getText();
    }

    public void setSource(String source) {
        if (source != null) {
            this.sourceField.setText(source);
        } else {
            this.sourceField.setText("");
        }
    }

    public boolean validate() {
        return true;
    }

    public void handleEvent(Event event) {
        this.notifyChangeListeners((Object)this);
    }

    public boolean setFocus() {
        this.titleField.setSelection(0, this.titleField.getText().length());
        return this.titleField.setFocus();
    }

    public String getMessage() {
        return this.message.getMessage();
    }

    public int getMessageType() {
        return this.message.getMessageType();
    }

    public void notifyChangeListeners(Object source) {
        this.notifier.notifyChangeListeners(source);
    }

    public void addChangeListener(ChangeListener listener) {
        this.notifier.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.notifier.removeChangeListener(listener);
    }

    public void allowNotifications() {
        this.notifier.allowNotifications();
    }

    public void suppressNotifications() {
        this.notifier.suppressNotifications();
    }
}

