/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MessageBar
extends Composite {
    int horizontalPixelsPerChar;
    String message = "";
    Image image = null;
    Label messageImage;
    Text messageText;

    public MessageBar(Composite parent, int style) {
        super(parent, style);
        JFaceColors.setColors((Control)this, (Color)parent.getForeground(), (Color)parent.getBackground());
        this.createControl(this);
    }

    protected void createControl(Composite parent) {
        GC gc = new GC((Drawable)parent);
        this.horizontalPixelsPerChar = gc.getFontMetrics().getHeight();
        gc.dispose();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.messageImage = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 131072;
        data.verticalAlignment = 128;
        data.heightHint = 16;
        data.widthHint = 16;
        this.messageImage.setLayoutData((Object)data);
        JFaceColors.setColors((Control)this.messageImage, (Color)parent.getForeground(), (Color)parent.getBackground());
        this.messageText = new Text(parent, 72);
        this.messageText.setText(" \n ");
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 16384;
        data.verticalAlignment = 128;
        data.heightHint = 2 * this.horizontalPixelsPerChar;
        this.messageText.setLayoutData((Object)data);
        JFaceColors.setColors((Control)this.messageText, (Color)parent.getForeground(), (Color)parent.getBackground());
    }

    public boolean setMessage(IMessageProvider msg) {
        return this.setMessage(msg.getMessage(), msg.getMessageType());
    }

    public boolean setMessage(String newMessage, int type) {
        Image newImage = null;
        if (newMessage != null) {
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_info_image");
                    break;
                }
                case 2: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                    break;
                }
                case 3: {
                    newImage = JFaceResources.getImage((String)"dialog_message_error_image");
                }
            }
        }
        return this.showMessage(newMessage, newImage);
    }

    protected boolean showMessage(String newMessage, Image newImage) {
        if (this.message.equals(newMessage) && this.image == newImage) {
            return false;
        }
        this.message = newMessage != null ? newMessage : "";
        this.image = newImage;
        if (this.messageImage != null) {
            this.messageImage.setImage(this.image);
        }
        if (this.messageText != null) {
            this.messageText.setText(this.message);
        }
        this.layout(true, true);
        return true;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (color != null) {
            if (this.messageImage != null) {
                this.messageImage.setBackground(color);
            }
            if (this.messageText != null) {
                this.messageText.setBackground(color);
            }
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (color != null) {
            if (this.messageImage != null) {
                this.messageImage.setForeground(color);
            }
            if (this.messageText != null) {
                this.messageText.setForeground(color);
            }
        }
    }
}

