/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.document;

import edu.mit.story.ui.IStoryUIConstants;
import edu.mit.story.ui.document.IStoryDocument;
import edu.mit.story.ui.document.StoryPartitionScanner;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IDocumentSetupParticipantExtension;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class StoryDocumentSetupParticipant
implements IDocumentSetupParticipant,
IDocumentSetupParticipantExtension {
    public static IPartitionTokenScanner partitionScanner = new StoryPartitionScanner();

    public void setup(IDocument document) {
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            FastPartitioner partitioner = new FastPartitioner(partitionScanner, IStoryUIConstants.PARTITION_TYPES_Story);
            extension3.setDocumentPartitioner("story_partitioning", (IDocumentPartitioner)partitioner);
            partitioner.connect(document);
        }
    }

    public void setup(IDocument doc, IPath location, LocationKind locationKind) {
        this.setup(doc);
        if (doc instanceof IStoryDocument) {
            IStoryDocument storyDoc = (IStoryDocument)doc;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(location);
            storyDoc.setCorpus(file.getProject().getName());
        }
    }
}

