/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.content;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepManager;
import edu.mit.story.core.rep.IRepSupporter;
import edu.mit.story.core.rep.RepUtils;
import edu.mit.story.core.util.ArrayUtils;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class RepContentProvider
implements ITreeContentProvider {
    IRepManager fManager;
    boolean fProvidingSubtree;

    public RepContentProvider() {
        this(true);
    }

    public RepContentProvider(boolean showDescendants) {
        this(StoryPlugin.getDefault().getRepManager(), showDescendants);
    }

    public RepContentProvider(IRepManager manager) {
        this(manager, true);
    }

    public RepContentProvider(IRepManager manager, boolean showDescendants) {
        if (manager == null) {
            throw new NullPointerException();
        }
        this.fManager = manager;
        this.fProvidingSubtree = showDescendants;
    }

    public boolean isProvidingSubtree() {
        return this.fProvidingSubtree;
    }

    public void setProvidingSubtree(boolean value) {
        if (this.fProvidingSubtree == value) {
            return;
        }
        this.fProvidingSubtree = value;
    }

    public Object[] getElements(Object input) {
        if (input instanceof IHasRep) {
            IRep rep = ((IHasRep)input).getRep();
            if (rep == null) {
                return ArrayUtils.emptyArray(Object.class);
            }
            return new Object[]{rep};
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (!(parent instanceof IRep)) {
            return null;
        }
        if (this.fProvidingSubtree) {
            return RepUtils.getAllDependents((IRep)((IRep)parent), (IRepSupporter)this.fManager).toArray();
        }
        return ((IRep)parent).getAntecedents().toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IRep) {
            if (this.fProvidingSubtree) {
                return !RepUtils.getAllDependents((IRep)((IRep)element), (IRepSupporter)this.fManager).isEmpty();
            }
            return ((IRep)element).getAntecedents().size() > 0;
        }
        if (element instanceof IHasRep) {
            return ((IHasRep)element).getRep() != null;
        }
        return false;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

