/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.actions;

import edu.mit.story.core.desc.DescMultiSet;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescMultiSet;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.descriptor.IHasDescription;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.element.IStoryElement;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.IUtilityClass;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.clipboard.ClipboardUtils;
import edu.mit.story.ui.dialogs.DescEditingDialog;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DescActionUtils
implements IUtilityClass {
    private DescActionUtils() {
    }

    public static boolean canCut(IDesc desc, IMutableStoryModel provider) {
        return DescActionUtils.canDelete(desc, provider) & DescActionUtils.canCopy(desc);
    }

    public static boolean canCut(IDescSet descs, IMutableStoryModel provider) {
        return DescActionUtils.canDelete((Collection<? extends IDesc>)descs, provider) & DescActionUtils.canCopy(descs);
    }

    public static boolean canCut(IDescMultiSet descs, IMutableStoryModel provider) {
        return DescActionUtils.canDelete((Collection<? extends IDesc>)descs, provider) & DescActionUtils.canCopy(descs);
    }

    public static boolean canCopy(IDesc desc) {
        return desc != null;
    }

    public static boolean canCopy(IDescSet descs) {
        if (descs == null) {
            return false;
        }
        return !descs.isEmpty();
    }

    public static boolean canCopy(IDescMultiSet descs) {
        if (descs == null) {
            return false;
        }
        return !descs.isEmpty();
    }

    public static boolean canPaste(IDesc desc, IStoryModel provider) {
        if (desc == null | provider == null) {
            return false;
        }
        if (!(provider instanceof IMutableStoryModel)) {
            return false;
        }
        return desc.getRep().equals(provider.getPrimary());
    }

    public static boolean canPaste(IDescSet descSets, IStoryModel provider) {
        if (descSets == null | provider == null) {
            return false;
        }
        if (descSets.isEmpty()) {
            return false;
        }
        for (IDesc descSet : descSets) {
            if (!descSet.getRep().equals(provider.getPrimary())) continue;
            return true;
        }
        return false;
    }

    public static boolean canPaste(IDescMultiSet descMap, IStoryModel provider) {
        if (descMap == null | provider == null) {
            return false;
        }
        if (!descMap.isEmpty()) {
            return false;
        }
        IDescSet descSet = descMap.getDescriptions(provider.getPrimary());
        if (descSet == null) {
            return false;
        }
        if (descSet.isEmpty()) {
            return false;
        }
        Iterator i = descMap.repIterator();
        while (i.hasNext()) {
            if (provider.supports((IRep)i.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean canDelete(IDesc desc, IStoryEditor editor) {
        if (editor == null || !editor.isMutable()) {
            return false;
        }
        return DescActionUtils.canDelete(desc, (IMutableStoryModel)editor.getStoryModel());
    }

    public static boolean canDelete(IDesc desc, IMutableStoryModel provider) {
        if (desc == null || provider == null) {
            return false;
        }
        return !desc.getRep().equals(provider.getPrimary());
    }

    public static boolean canDelete(Collection<? extends IDesc> descs, IStoryEditor editor) {
        if (editor == null || !editor.isMutable()) {
            return false;
        }
        return DescActionUtils.canDelete(descs, (IMutableStoryModel)editor.getStoryModel());
    }

    public static boolean canDelete(Collection<? extends IDesc> descs, IMutableStoryModel provider) {
        if (descs == null || descs.isEmpty() || provider == null) {
            return false;
        }
        for (IDesc iDesc : descs) {
            if (!iDesc.getRep().equals(provider.getPrimary())) continue;
            return false;
        }
        return true;
    }

    public static boolean doCut(Object source, IDesc desc, IMutableStoryModel provider, Clipboard clipboard) {
        if (clipboard == null) {
            return false;
        }
        if (!DescActionUtils.canCut(desc, provider)) {
            return false;
        }
        if (!DescActionUtils.doDelete(source, desc, provider)) {
            return false;
        }
        DescActionUtils.doCopy(source, desc, clipboard);
        return true;
    }

    public static boolean doCut(Object source, IDescSet descs, IMutableStoryModel provider, Clipboard clipboard) {
        if (clipboard == null) {
            return false;
        }
        if (!DescActionUtils.canCut(descs, provider)) {
            return false;
        }
        if (!DescActionUtils.doDelete(source, (Collection<? extends IDesc>)descs, provider)) {
            return false;
        }
        DescActionUtils.doCopy(source, descs, clipboard);
        return true;
    }

    public static boolean doCut(Object source, IDescMultiSet descs, IMutableStoryModel provider, Clipboard clipboard) {
        if (clipboard == null) {
            return false;
        }
        if (!DescActionUtils.canCut(descs, provider)) {
            return false;
        }
        if (!DescActionUtils.doDelete(source, (Collection<? extends IDesc>)descs, provider)) {
            return false;
        }
        DescActionUtils.doCopy(source, descs, clipboard);
        return true;
    }

    public static boolean doCopy(Object source, IDesc desc, Clipboard clipboard) {
        return true;
    }

    public static boolean doCopy(Object source, IDescSet descs, Clipboard clipboard) {
        if (clipboard == null) {
            return false;
        }
        if (!DescActionUtils.canCopy(descs)) {
            return false;
        }
        ClipboardUtils.putStoryObject((IStoryElement)descs, clipboard);
        return true;
    }

    public static boolean doCopy(Object source, IDescMultiSet descs, Clipboard clipboard) {
        if (clipboard == null) {
            return false;
        }
        if (!DescActionUtils.canCopy(descs)) {
            return false;
        }
        ClipboardUtils.putStoryObject((IStoryElement)descs, clipboard);
        return true;
    }

    public static boolean doCopyData(Object source, IDesc desc, Clipboard clipboard) {
        return true;
    }

    public static boolean doCopyData(Object source, IDescSet descs, Clipboard clipboard) {
        if (clipboard == null) {
            return false;
        }
        if (!DescActionUtils.canCopy(descs)) {
            return false;
        }
        ClipboardUtils.putStoryObjectData((IStoryElement)descs, clipboard);
        return true;
    }

    public static boolean doCopyData(Object source, IDescMultiSet descs, Clipboard clipboard) {
        if (clipboard == null) {
            return false;
        }
        if (!DescActionUtils.canCopy(descs)) {
            return false;
        }
        ClipboardUtils.putStoryObjectData((IStoryElement)descs, clipboard);
        return true;
    }

    public static boolean doDelete(Object source, IDesc desc, IMutableStoryModel provider) {
        return DescActionUtils.doDelete(source, Collections.singleton(desc), provider);
    }

    public static boolean doDelete(Object source, Collection<? extends IDesc> descs, IMutableStoryModel provider) {
        if (!DescActionUtils.canDelete(descs, provider)) {
            return false;
        }
        RemoveDescriptionsChange change = new RemoveDescriptionsChange(descs);
        provider.applyChange(source, (IModelChange)change, false);
        return true;
    }

    public static boolean canEdit(IDesc desc, IStoryEditor editor) {
        if (desc == null || editor == null) {
            return false;
        }
        if (!editor.isMutable()) {
            return false;
        }
        return DescActionUtils.canEdit(desc, (IMutableStoryModel)editor.getStoryModel());
    }

    public static boolean canEdit(IDesc desc, IMutableStoryModel provider) {
        if (desc == null) {
            return false;
        }
        return !provider.getPrimary().isType((IHasRep)desc);
    }

    public static boolean doEdit(Object source, IDesc desc, IMutableStoryModel provider, IStoryEditor editor) {
        if (!DescActionUtils.canDelete(desc, provider)) {
            return false;
        }
        return DescActionUtils.editDescription(source, desc, editor);
    }

    public static boolean doEdit(Object source, IDescSet descs, IMutableStoryModel provider, IStoryEditor editor) {
        if (!DescActionUtils.canDelete((Collection<? extends IDesc>)descs, provider)) {
            return false;
        }
        for (IDesc desc : descs) {
            if (DescActionUtils.editDescription(source, desc, editor)) continue;
            return false;
        }
        return true;
    }

    public static Answer promptForCascade(Shell shell) {
        String cascade = StoryUIPlugin.getDefault().getPreferenceStore().getString("CascadeDirectDescriptionChanges");
        PromptPref result = PromptPref.valueOf(cascade);
        if (result == null) {
            result = PromptPref.prompt;
        }
        if (result == PromptPref.prompt) {
            switch (DescActionUtils.showDescriptionCascadePrompt(shell)) {
                case 2: {
                    return Answer.YES;
                }
                case 3: {
                    return Answer.NO;
                }
            }
        } else {
            if (result == PromptPref.always) {
                return Answer.YES;
            }
            if (result == PromptPref.never) {
                return Answer.NO;
            }
        }
        return null;
    }

    public static int showDescriptionCascadePrompt(Shell shell) {
        IPreferenceStore store = StoryUIPlugin.getDefault().getPreferenceStore();
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)shell, (String)StoryUIMessages.DIALOG_PromptForCascade_title, (String)StoryUIMessages.MSG_PromptForCascade, null, (boolean)false, (IPreferenceStore)store, (String)"CascadeDirectDescriptionChanges");
        return dialog.getReturnCode();
    }

    public static boolean canCreateDescriptions(IStoryEditor editor) {
        return editor != null && editor.isMutable();
    }

    public static boolean editDescription(Object source, IDesc oldDesc, IStoryEditor editor) {
        Date start = new Date();
        DescEditingDialog dialog = new DescEditingDialog(oldDesc, editor, editor.getSite().getShell());
        if (dialog.open() != 0 || !dialog.isDescriptionChanged()) {
            return false;
        }
        Timing timing = new Timing(start, "user");
        SimplePosition newPos = new SimplePosition(dialog.getOffset(), dialog.getLength());
        ChangeUtils.edit((Object)source, (IMutableStoryModel)editor.getStoryModel(), (IRep)oldDesc.getRep(), (IHasPosition)newPos, (IData)dialog.getData(), (ITiming)timing, (IDesc)oldDesc);
        return true;
    }

    public static IDesc extractSingle(ISelection selection, IRep rep) {
        if (rep == null) {
            return null;
        }
        IStructuredSelection struct = SelectionUtils.castAsStructuredSelection(selection);
        if (struct == null) {
            return null;
        }
        IDesc result = null;
        for (Object element : struct) {
            IDesc desc;
            if (!(element instanceof IDesc) || !rep.isType((IHasRep)(desc = (IDesc)element))) continue;
            if (result != null) {
                return null;
            }
            result = desc;
        }
        return result;
    }

    public static IDescMultiSet extractDescriptions(ISelection selection) {
        IStructuredSelection struct = SelectionUtils.castAsStructuredSelection(selection);
        if (struct == null) {
            return null;
        }
        HashSet<IDesc> descs = null;
        for (Object element : struct) {
            if (!(element instanceof IDesc)) continue;
            if (descs == null) {
                descs = new HashSet<IDesc>();
            }
            descs.add((IDesc)element);
        }
        return descs == null ? null : new DescMultiSet(descs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Answer {
        YES,
        NO;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PromptPref implements IHasName,
    IHasDescription
    {
        always("Always", "Always", "always"),
        never("Never", "Never", "never"),
        prompt("Prompt", "Prompt", "prompt");

        private final String name;
        private final String desc;
        private final String pref;

        private PromptPref(String name, String desc, String pref) {
            this.name = name;
            this.desc = desc;
            this.pref = pref;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }

        public String getPreferenceValue() {
            return this.pref;
        }
    }
}

